/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLE_MESSAGE_H__
#define __GLE_MESSAGE_H__

#include        <gle/glemisc.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define	GLE_TYPE_MESSAGE_BOX		(gle_message_box_get_type ())
#define GLE_MESSAGE_BOX(object)		(GTK_CHECK_CAST ((object), GLE_TYPE_MESSAGE_BOX, GleMessageBox))
#define GLE_MESSAGE_BOX_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), GLE_TYPE_MESSAGE_BOX, GleMessageBoxClass))
#define GLE_IS_MESSAGE_BOX(object)	(GTK_CHECK_TYPE ((object), GLE_TYPE_MESSAGE_BOX))
#define GLE_IS_MESSAGE_BOX_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GLE_TYPE_MESSAGE_BOX))


typedef struct  _GleMessageBox		GleMessageBox;
typedef struct  _GleMessageBoxClass	GleMessageBoxClass;


struct  _GleMessageBox
{
  GtkWindow     window;

  GtkWidget	*text_label;
};

struct  _GleMessageBoxClass
{
  GtkWindowClass        parent_class;
};


GtkType         gle_message_box_get_type	(void);
GtkWidget*      gle_message_box_new		(const gchar	*message);
void		gle_message_box_set_text	(GleMessageBox	*mb,
						 const gchar	*message);
void		gle_message_box_set_textf	(GleMessageBox	*mb,
						 const gchar	*message_format,
						 ...) G_GNUC_PRINTF (2, 3);
GtkWidget*	gle_message_box_popup		(GtkObject      *alive_object,
						 const gchar    *message_format,
						 ...) G_GNUC_PRINTF (2, 3);



#ifdef __cplusplus
}
#endif /* __cplusplus */
								   
#endif /* __GLE_MESSAGE_H__ */
