/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class cvc_enumeration_validCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        Range range = request.getRange();
        try {
            int offset = document.offsetAt(range.getStart());
            DOMNode node = document.findNodeBefore(offset);
            if (node != null && node.isElement()) {
                DOMElement element = (DOMElement)node;
                ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
                for (CMDocument cmDocument : contentModelManager.findCMDocument(element)) {
                    CMElementDeclaration cmElement = cmDocument.findCMElement(element);
                    if (cmElement == null) continue;
                    cmElement.getEnumerationValues().forEach(value -> {
                        CodeAction replaceTextContentAction = CodeActionFactory.replace("Replace with '" + value + "'", range, value, document.getTextDocument(), diagnostic);
                        codeActions.add(replaceTextContentAction);
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

