/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.gemini.web.internal.url.DirTransformer;
import org.eclipse.virgo.util.io.PathReference;

final class DirTransformingURLConnection
extends URLConnection {
    private static final String TEMP_DIR = "file:temp/";
    private final DirTransformer transformer;
    private final boolean ensureManifestIsPresent;
    private final Object monitor = new Object();
    private URL transformedURL;

    DirTransformingURLConnection(URL url, DirTransformer transformer) throws MalformedURLException {
        this(url, transformer, false);
    }

    DirTransformingURLConnection(URL url, DirTransformer transformer, boolean ensureManifestIsPresent) throws MalformedURLException {
        super(url);
        this.transformer = transformer;
        this.ensureManifestIsPresent = ensureManifestIsPresent;
        this.transformedURL = new URL(TEMP_DIR + this.getPath());
        PathReference transformedDir = new PathReference(this.transformedURL.getPath());
        transformedDir.delete(true);
    }

    @Override
    public void connect() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.transformer.transform(this.url, this.transformedURL, this.ensureManifestIsPresent);
            return this.transformedURL.openStream();
        }
    }

    private String getPath() {
        String path = this.url.getPath();
        int index = path.lastIndexOf(47);
        if (index > -1) {
            path = path.substring(index + 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL() {
        Object object = this.monitor;
        synchronized (object) {
            return this.transformedURL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransformedURL(URL transformedURL) {
        Object object = this.monitor;
        synchronized (object) {
            this.transformedURL = transformedURL;
        }
    }
}

