/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.encoding.HTVarInt;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;

public class PotentialLeakSegment
extends BasicSegment
implements INamedSegment {
    public static final @NonNull IHTIntervalReader<@NonNull ISegment> MEMORY_SEGMENT_READ_FACTORY = buffer -> {
        long start = buffer.getLong();
        return new PotentialLeakSegment(start, start + HTVarInt.readLong((ISafeByteBufferReader)buffer), buffer.getLong());
    };
    private static final long serialVersionUID = 4906743387056014569L;
    private final Long fTid;

    public PotentialLeakSegment(long start, long end, Long tid) {
        super(start, end);
        this.fTid = tid;
    }

    public int getSizeOnDisk() {
        return 16 + HTVarInt.getEncodedLengthLong((long)(this.getEnd() - this.getStart()));
    }

    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.getStart());
        HTVarInt.writeLong((ISafeByteBufferWriter)buffer, (long)(this.getEnd() - this.getStart()));
        buffer.putLong(this.fTid.longValue());
    }

    public @NonNull Integer getTid() {
        return this.fTid.intValue();
    }

    public @NonNull String getName() {
        return String.valueOf(this.getTid());
    }
}

