/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;

public class TmfUiRefreshHandler {
    private static TmfUiRefreshHandler fInstance = null;
    private final Map<Object, Runnable> fUpdates = new LinkedHashMap<Object, Runnable>();
    private Thread fCurrentTask = null;

    private TmfUiRefreshHandler() {
    }

    public static synchronized TmfUiRefreshHandler getInstance() {
        if (fInstance == null) {
            fInstance = new TmfUiRefreshHandler();
        }
        return fInstance;
    }

    public synchronized void dispose() {
        this.fUpdates.clear();
        this.fCurrentTask = null;
    }

    public synchronized void queueUpdate(Object source, Runnable task) {
        this.fUpdates.put(source, task);
        if (this.fCurrentTask == null) {
            this.fCurrentTask = new RunAllUpdates();
            this.fCurrentTask.start();
        }
    }

    private class RunAllUpdates
    extends Thread {
        private RunAllUpdates() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable nextTask = null;
                TmfUiRefreshHandler tmfUiRefreshHandler = TmfUiRefreshHandler.this;
                synchronized (tmfUiRefreshHandler) {
                    if (!TmfUiRefreshHandler.this.fUpdates.isEmpty()) {
                        Object firstKey = TmfUiRefreshHandler.this.fUpdates.keySet().iterator().next();
                        nextTask = TmfUiRefreshHandler.this.fUpdates.get(firstKey);
                        TmfUiRefreshHandler.this.fUpdates.remove(firstKey);
                    }
                    if (nextTask == null) {
                        TmfUiRefreshHandler.this.fCurrentTask = null;
                        break;
                    }
                }
                try {
                    Display.getDefault().syncExec(nextTask);
                }
                catch (Exception e) {
                    Activator.getDefault().logError("Exception thrown by TmfUiRefreshHandler task", e);
                }
            }
        }
    }
}

