/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.table;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableCell;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableLine;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public class EventTableLine
extends VirtualTableLine {
    private final ITmfTimestamp fTimestamp;
    private final long fRank;
    private final long fRepeatCount;

    public EventTableLine(List<VirtualTableCell> data, long index, ITmfTimestamp timestamp, long rank, long repeatCount) {
        super(index, data);
        this.fTimestamp = timestamp;
        this.fRank = rank;
        this.fRepeatCount = repeatCount;
    }

    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    public long getRank() {
        return this.fRank;
    }

    public long getRepeatCount() {
        return this.fRepeatCount;
    }

    public String toString() {
        return "Index: " + this.getIndex() + ", Line: " + String.valueOf(this.getCells()) + ", Timestamp: " + String.valueOf(this.fTimestamp) + ", Rank: " + this.fRank + ", RepeatCount: " + this.fRepeatCount + ", ActiveProperties: " + this.getActiveProperties();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventTableLine other = (EventTableLine)obj;
        return this.fTimestamp.equals(other.getTimestamp()) && this.fRank == other.getRank() && this.fRepeatCount == other.fRepeatCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fTimestamp, this.fRank, this.fRepeatCount, this.getIndex(), this.getCells());
    }
}

