/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types.composite;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderDefinition;

@NonNullByDefault
public final class EventHeaderCompactDeclaration
extends Declaration
implements IEventHeaderDeclaration {
    private static final int BASE_10 = 10;
    private static final int COMPACT_ID = 5;
    private static final int EXTENDED_VALUE = 31;
    private static final int ID_SIZE = 32;
    private static final int FULL_TS = 64;
    private static final int COMPACT_TS = 27;
    private static final String CLOCK = "";
    private static final int MAX_SIZE = 104;
    private static final int ALIGN_ON_1 = 1;
    private static final int ALIGN_ON_8 = 8;
    private final ByteOrder fByteOrder;
    private final List<StructDeclaration> fReferenceStructs = new ArrayList<StructDeclaration>();
    private static final EventHeaderCompactDeclaration EVENT_HEADER_BIG_ENDIAN = new EventHeaderCompactDeclaration(EventHeaderCompactDeclaration.nullCheck(ByteOrder.BIG_ENDIAN));
    private static final EventHeaderCompactDeclaration EVENT_HEADER_LITTLE_ENDIAN = new EventHeaderCompactDeclaration(EventHeaderCompactDeclaration.nullCheck(ByteOrder.LITTLE_ENDIAN));

    private EventHeaderCompactDeclaration(ByteOrder byteOrder) {
        this.fByteOrder = byteOrder;
        this.populateReferences();
    }

    private void populateReferences() {
        if (!this.fReferenceStructs.isEmpty()) {
            return;
        }
        StructDeclaration ref = new StructDeclaration(8L);
        EnumDeclaration id = new EnumDeclaration(IntegerDeclaration.createDeclaration(5, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 1L, "event-record-class-id"));
        id.add(0L, 30L, "compact");
        id.add(31L, 31L, "extended");
        ref.addField("id", id);
        VariantDeclaration v = new VariantDeclaration();
        StructDeclaration compact = new StructDeclaration(1L);
        compact.addField("timestamp", IntegerDeclaration.createDeclaration(27, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 1L, "default-clock-timestamp"));
        StructDeclaration extended = new StructDeclaration(8L);
        extended.addField("id", IntegerDeclaration.createDeclaration(32, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L, "event-record-class-id"));
        extended.addField("timestamp", IntegerDeclaration.createDeclaration(64, false, 10, this.fByteOrder, Encoding.NONE, CLOCK, 8L, "default-clock-timestamp"));
        v.addField("compact", compact);
        v.addField("extended", extended);
        ref.addField("v", v);
        this.fReferenceStructs.add(ref);
    }

    public static EventHeaderCompactDeclaration getEventHeader(@Nullable ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return EVENT_HEADER_BIG_ENDIAN;
        }
        return EVENT_HEADER_LITTLE_ENDIAN;
    }

    @Override
    public EventHeaderDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        ByteOrder bo = input.getByteOrder();
        input.setByteOrder(this.fByteOrder);
        int enumId = (int)input.get(5, false);
        if (enumId != 31) {
            long timestamp2 = input.get(27, false);
            input.setByteOrder(bo);
            return new EventHeaderDefinition(this, enumId, timestamp2, 27);
        }
        input.position(input.position() + 3L);
        long id = input.get(32, false);
        if (id > Integer.MAX_VALUE) {
            throw new CTFException("ID " + id + " larger than " + Integer.MAX_VALUE + " is currently unsupported by the parser");
        }
        long timestampLong = input.get(64, false);
        input.setByteOrder(bo);
        return new EventHeaderDefinition(this, (int)id, timestampLong, 64);
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return 104;
    }

    public boolean isCompactEventHeader(@Nullable StructDeclaration declaration) {
        if (declaration == null) {
            return false;
        }
        for (IDeclaration iDeclaration : this.fReferenceStructs) {
            if (!iDeclaration.isBinaryEquivalent(declaration)) continue;
            return true;
        }
        return false;
    }

    private static ByteOrder nullCheck(@Nullable ByteOrder bo) {
        if (bo == null) {
            throw new IllegalStateException("Could not create byteorder");
        }
        return bo;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fByteOrder.equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventHeaderCompactDeclaration other = (EventHeaderCompactDeclaration)obj;
        return this.fByteOrder.equals(other.fByteOrder);
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration other) {
        for (StructDeclaration referenceStruct : this.fReferenceStructs) {
            if (!referenceStruct.isBinaryEquivalent(other)) continue;
            return true;
        }
        return false;
    }
}

