/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.buildpath.BuildPathParser;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.test.ComposerCoreTestPlugin;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class BuildPathTest {
    private IProject project;
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();

    @Test
    public void testBuildpathParser() throws CoreException, IOException, InterruptedException {
        this.project = TestUtils.createProject((String)"buildpath");
        Assert.assertNotNull((Object)this.project);
        ComposerCoreTestPlugin.copyProjectFiles(this.project);
        this.project.refreshLocal(2, null);
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3);
        PHPFacets.setFacetedVersion((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3);
        FacetManager.installFacets((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3, (IProgressMonitor)new NullProgressMonitor());
        this.project.build(6, null);
        TestUtils.waitForAutoBuild();
        IFile file = this.project.getFile("composer.json");
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)this.project.hasNature("org.eclipse.php.core.PHPNature"));
        Assert.assertTrue((boolean)FacetManager.hasComposerFacet((IProject)this.project));
        IComposerProject composerProject = ComposerPlugin.getDefault().getComposerProject(this.project);
        BuildPathParser parser = new BuildPathParser(composerProject);
        List paths = parser.getPathsInfo().stream().map(e -> e.path).collect(Collectors.toList());
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("mordor/composer", "mordor/gossi/ldap/src", "mordor/phing/phing/classes/phing", "mordor/propel/propel1/generator/lib", "mordor/propel/propel1/runtime/lib", "mordor/symfony/console", "nother", "src", "test"));
        Assert.assertArrayEquals((Object[])paths.toArray(), (Object[])expected.toArray());
    }

    @After
    public void cleanup() throws CoreException {
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }
}

