/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.PHPContentOutlineConfiguration;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;

public class PHPContextActivator
implements IWindowListener,
IPartListener2 {
    private static final PHPContextActivator INSTANCE = new PHPContextActivator();
    private Map<CommonNavigator, NavigatorSelectionListener> navigatorListener = new HashMap<CommonNavigator, NavigatorSelectionListener>();
    private Map<ContentOutline, IContextActivation> outlineContexts = new HashMap<ContentOutline, IContextActivation>();

    private PHPContextActivator() {
    }

    public boolean isPHPPerspective(IWorkbenchPage page) {
        return page.getPerspective() != null && page.getPerspective().getId().equals("org.eclipse.php.perspective");
    }

    public static PHPContextActivator getInstance() {
        return INSTANCE;
    }

    public void install() {
        IWorkbenchWindow window;
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            window = iWorkbenchWindowArray[n2];
            window.getPartService().addPartListener((IPartListener2)this);
            ++n2;
        }
        window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IWorkbenchPartReference partReference = page.getActivePartReference();
        if (partReference == null) {
            return;
        }
        this.partActivated(partReference);
    }

    public void uninstall() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.removeWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            window.getPartService().removePartListener((IPartListener2)this);
            ++n2;
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof CommonNavigator) {
            this.commonNavigatorActivated((CommonNavigator)part);
        } else if (part instanceof ContentOutline) {
            this.outlineActivated((ContentOutline)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof CommonNavigator) {
            this.commonNavigatorClosed((CommonNavigator)part);
        } else if (part instanceof ContentOutline) {
            this.outlineClosed((ContentOutline)part);
        }
    }

    private void outlineActivated(ContentOutline part) {
        IContextService contextService = (IContextService)part.getViewSite().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        if (this.isPHPRelevantPage(part.getCurrentPage(), part.getViewSite().getPage())) {
            if (!this.outlineContexts.containsKey(part)) {
                this.outlineContexts.put(part, contextService.activateContext("org.eclipse.dltk.ui.context.views"));
            }
        } else if (this.outlineContexts.containsKey(part)) {
            contextService.deactivateContext(this.outlineContexts.remove(part));
        }
    }

    private boolean isPHPRelevantPage(IPage outline, IWorkbenchPage page) {
        if (outline instanceof MessagePage && this.isPHPPerspective(page)) {
            return true;
        }
        return outline instanceof ConfigurableContentOutlinePage && ((ConfigurableContentOutlinePage)outline).getConfiguration() instanceof PHPContentOutlineConfiguration;
    }

    private void outlineClosed(ContentOutline part) {
        this.outlineContexts.remove(part);
    }

    private void commonNavigatorActivated(CommonNavigator part) {
        if (!this.navigatorListener.containsKey(part)) {
            NavigatorSelectionListener listener = new NavigatorSelectionListener(part.getSite());
            listener.install();
            this.navigatorListener.put(part, listener);
        }
    }

    private void commonNavigatorClosed(CommonNavigator part) {
        NavigatorSelectionListener listener = this.navigatorListener.get(part);
        if (listener != null) {
            listener.uninstall();
            this.navigatorListener.remove(part);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener2)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
    }

    private class NavigatorSelectionListener
    implements ISelectionChangedListener {
        private IContextService contextService;
        private IWorkbenchPartSite site;
        private IContextActivation activation;

        public NavigatorSelectionListener(IWorkbenchPartSite site) {
            this.site = site;
            this.contextService = (IContextService)site.getService(IContextService.class);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.validateSelection(event.getSelection());
        }

        private void validateSelection(ISelection selection) {
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && this.isRelevant(((IStructuredSelection)selection).getFirstElement())) {
                if (this.activation == null) {
                    this.activation = this.contextService.activateContext("org.eclipse.dltk.ui.context.views");
                }
            } else if (PHPContextActivator.this.isPHPPerspective(this.site.getPage())) {
                if (this.activation == null) {
                    this.activation = this.contextService.activateContext("org.eclipse.dltk.ui.context.views");
                }
            } else if (this.activation != null) {
                this.contextService.deactivateContext(this.activation);
                this.activation = null;
            }
        }

        private boolean isRelevant(Object selection) {
            if (selection instanceof IModelElement) {
                return true;
            }
            if (selection instanceof IResource) {
                try {
                    if (PHPToolkitUtil.isPHPProject((IProject)((IResource)selection).getProject())) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    PHPUiPlugin.log(e);
                }
            }
            return false;
        }

        public void install() {
            if (this.contextService == null) {
                return;
            }
            ISelectionProvider provider = this.site.getSelectionProvider();
            if (provider != null) {
                provider.addSelectionChangedListener((ISelectionChangedListener)this);
                this.validateSelection(provider.getSelection());
            }
        }

        public void uninstall() {
            if (this.site.getSelectionProvider() != null) {
                this.site.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }
}

