/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.actions;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.php.composer.ui.editor.composer.ComposerFormEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;

public abstract class ComposerAction
extends Action {
    protected String id;
    protected Command command;
    protected IProject project;
    protected IWorkbenchPartSite site;

    public ComposerAction(IProject project, IWorkbenchPartSite site, String commandId) {
        this.project = project;
        this.site = site;
        this.id = commandId;
        this.command = ((ICommandService)site.getService(ICommandService.class)).getCommand(this.id);
    }

    public String getToolTipText() {
        try {
            return this.command.getDescription();
        }
        catch (NotDefinedException notDefinedException) {
            return null;
        }
    }

    protected void ensureSaved() {
        ComposerFormEditor editor = null;
        IEditorPart part = this.site.getPage().getActiveEditor();
        if (part instanceof ComposerFormEditor) {
            editor = (ComposerFormEditor)part;
        }
        if (editor != null && editor.isDirty()) {
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

