/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.FormatterUIPlugin;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProfileDialog
extends StatusDialog {
    private static final String PREF_OPEN_EDIT_DIALOG = "org.eclipse.php.formatter.ui.codeformatter.create_profile_dialog.open_edit";
    private Text fNameText;
    private Combo fProfileCombo;
    private Button fEditCheckbox;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, FormatterMessages.CreateProfileDialog_status_message_profile_name_is_empty);
    private static final StatusInfo fDuplicate = new StatusInfo(4, FormatterMessages.CreateProfileDialog_status_message_profile_with_this_name_already_exists);
    private final ProfileManager fProfileManager;
    private final List<ProfileManager.Profile> fSortedProfiles;
    private final String[] fSortedNames;
    private ProfileManager.CustomProfile fCreatedProfile;
    protected boolean fOpenEditDialog;

    public CreateProfileDialog(Shell parentShell, ProfileManager profileManager) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fSortedProfiles = this.fProfileManager.getSortedProfiles();
        this.fSortedNames = this.fProfileManager.getSortedDisplayNames();
    }

    public void create() {
        super.create();
        this.setTitle(FormatterMessages.CreateProfileDialog_dialog_title);
    }

    public Control createDialogArea(Composite parent) {
        int numColumns = 2;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText(FormatterMessages.CreateProfileDialog_profile_name_label_text);
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label profileLabel = new Label(composite, 64);
        profileLabel.setText(FormatterMessages.CreateProfileDialog_base_profile_label_text);
        profileLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite, 12);
        this.fProfileCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fEditCheckbox = new Button(composite, 32);
        this.fEditCheckbox.setText(FormatterMessages.CreateProfileDialog_open_edit_dialog_checkbox_text);
        this.fEditCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateProfileDialog.this.fOpenEditDialog = ((Button)e.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IDialogSettings dialogSettings = FormatterUIPlugin.getDefault().getDialogSettings();
        this.fOpenEditDialog = dialogSettings.get(PREF_OPEN_EDIT_DIALOG) != null ? dialogSettings.getBoolean(PREF_OPEN_EDIT_DIALOG) : true;
        this.fEditCheckbox.setSelection(this.fOpenEditDialog);
        this.fProfileCombo.setItems(this.fSortedNames);
        this.updateStatus((IStatus)fEmpty);
        CreateProfileDialog.applyDialogFont((Control)composite);
        this.fNameText.setFocus();
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus((IStatus)fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus((IStatus)fEmpty);
            return;
        }
        this.updateStatus((IStatus)fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK() || this.fProfileCombo.getSelectionIndex() == -1) {
            return;
        }
        FormatterUIPlugin.getDefault().getDialogSettings().put(PREF_OPEN_EDIT_DIALOG, this.fOpenEditDialog);
        Map<String, Object> preferences = this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex()).getSettings();
        String profileName = this.fNameText.getText();
        this.fCreatedProfile = new ProfileManager.CustomProfile(profileName, preferences);
        this.fProfileManager.addProfile(this.fCreatedProfile);
        super.okPressed();
    }

    public final ProfileManager.CustomProfile getCreatedProfile() {
        return this.fCreatedProfile;
    }

    public final boolean openEditDialog() {
        return this.fOpenEditDialog;
    }
}

