/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class DeselectOperation
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Deselect";
    private IViewer viewer;
    private List<IContentPart<? extends Node>> initialSelection;
    private List<IContentPart<? extends Node>> toBeDeselected;
    private ArrayList<IContentPart<? extends Node>> deselected;

    public DeselectOperation(IViewer viewer, List<? extends IContentPart<? extends Node>> toBeDeselected) {
        this(DEFAULT_LABEL, viewer, toBeDeselected);
    }

    public DeselectOperation(String label, IViewer viewer, List<? extends IContentPart<? extends Node>> toBeDeselected) {
        super(label);
        this.viewer = viewer;
        this.toBeDeselected = new ArrayList<IContentPart<? extends Node>>(toBeDeselected);
        SelectionModel selectionModel = this.getSelectionModel();
        this.initialSelection = new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = this.getSelectionModel();
        this.deselected = new ArrayList<IContentPart<? extends Node>>(this.toBeDeselected);
        this.deselected.retainAll(new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable()));
        selectionModel.removeFromSelection(this.deselected);
        return Status.OK_STATUS;
    }

    protected SelectionModel getSelectionModel() {
        return (SelectionModel)((Object)this.viewer.getAdapter(SelectionModel.class));
    }

    public List<IContentPart<? extends Node>> getToBeDeselected() {
        return this.toBeDeselected;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return Collections.disjoint(this.initialSelection, this.toBeDeselected);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setSelection(this.initialSelection);
        return Status.OK_STATUS;
    }
}

