/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ChangeSelectionOperation
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Change selection";
    private IViewer viewer;
    private List<IContentPart<? extends Node>> initialSelection;
    private List<IContentPart<? extends Node>> finalSelection;

    public ChangeSelectionOperation(IViewer viewer, List<? extends IContentPart<? extends Node>> finalSelection) {
        this(DEFAULT_LABEL, viewer, finalSelection);
    }

    public ChangeSelectionOperation(String label, IViewer viewer, List<? extends IContentPart<? extends Node>> finalSelection) {
        super(label);
        this.viewer = viewer;
        this.finalSelection = new ArrayList<IContentPart<? extends Node>>(finalSelection);
        SelectionModel selectionModel = this.getSelectionModel();
        this.initialSelection = new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = this.getSelectionModel();
        ArrayList<IContentPart<? extends Node>> currentSelection = new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
        if (!currentSelection.equals(this.finalSelection)) {
            selectionModel.setSelection(this.finalSelection);
        }
        return Status.OK_STATUS;
    }

    protected SelectionModel getSelectionModel() {
        return (SelectionModel)((Object)this.viewer.getAdapter(SelectionModel.class));
    }

    public List<IContentPart<? extends Node>> getToBeDeselected() {
        return this.finalSelection;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return this.initialSelection.equals(this.finalSelection);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = this.getSelectionModel();
        ArrayList<IContentPart<? extends Node>> currentSelection = new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
        if (!currentSelection.equals(this.initialSelection)) {
            selectionModel.setSelection(this.initialSelection);
        }
        return Status.OK_STATUS;
    }
}

