/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.shapes.ShapesExampleMessages;
import org.eclipse.gef.examples.shapes.ShapesPlugin;
import org.eclipse.gef.examples.shapes.model.Connection;
import org.eclipse.gef.examples.shapes.model.ModelElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class Shape
extends ModelElement {
    private static IPropertyDescriptor[] descriptors;
    private static final String HEIGHT_PROP = "Shape.Height";
    public static final String LOCATION_PROP = "Shape.Location";
    private static final long serialVersionUID = 1L;
    public static final String SIZE_PROP = "Shape.Size";
    public static final String SOURCE_CONNECTIONS_PROP = "Shape.SourceConn";
    public static final String TARGET_CONNECTIONS_PROP = "Shape.TargetConn";
    private static final String WIDTH_PROP = "Shape.Width";
    private static final String XPOS_PROP = "Shape.xPos";
    private static final String YPOS_PROP = "Shape.yPos";
    private final Point location = new Point(0, 0);
    private final Dimension size = new Dimension(50, 50);
    private final List<Connection> sourceConnections = new ArrayList<Connection>();
    private final List<Connection> targetConnections = new ArrayList<Connection>();

    static {
        IPropertyDescriptor[] iPropertyDescriptorArray = descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)XPOS_PROP, ShapesExampleMessages.Shape_X), new TextPropertyDescriptor((Object)YPOS_PROP, ShapesExampleMessages.Shape_Y), new TextPropertyDescriptor((Object)WIDTH_PROP, ShapesExampleMessages.Shape_Width), new TextPropertyDescriptor((Object)HEIGHT_PROP, ShapesExampleMessages.Shape_Height)};
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
            ((PropertyDescriptor)descriptor).setValidator(value -> {
                int intValue = -1;
                try {
                    intValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException exc) {
                    return ShapesExampleMessages.Shape_NotANumber;
                }
                return intValue >= 0 ? null : ShapesExampleMessages.Shape_ValueMustBeGreaterOrEqualZero;
            });
            ++n2;
        }
    }

    protected static Image createImage(String name) {
        return ImageDescriptor.createFromFile(ShapesPlugin.class, (String)name).createImage();
    }

    void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.add(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.add(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public abstract Image getIcon();

    public Point getLocation() {
        return this.location.getCopy();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (XPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.x);
        }
        if (YPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.y);
        }
        if (HEIGHT_PROP.equals(propertyId)) {
            return Integer.toString(this.size.height);
        }
        if (WIDTH_PROP.equals(propertyId)) {
            return Integer.toString(this.size.width);
        }
        return super.getPropertyValue(propertyId);
    }

    public Dimension getSize() {
        return this.size.getCopy();
    }

    public List<Connection> getSourceConnections() {
        return new ArrayList<Connection>(this.sourceConnections);
    }

    public List<Connection> getTargetConnections() {
        return new ArrayList<Connection>(this.targetConnections);
    }

    void removeConnection(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, conn, null);
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, conn, null);
        }
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (XPOS_PROP.equals(propertyId)) {
            int x = Integer.parseInt((String)value);
            this.setLocation(new Point(x, this.location.y));
        } else if (YPOS_PROP.equals(propertyId)) {
            int y = Integer.parseInt((String)value);
            this.setLocation(new Point(this.location.x, y));
        } else if (HEIGHT_PROP.equals(propertyId)) {
            int height = Integer.parseInt((String)value);
            this.setSize(new Dimension(this.size.width, height));
        } else if (WIDTH_PROP.equals(propertyId)) {
            int width = Integer.parseInt((String)value);
            this.setSize(new Dimension(width, this.size.height));
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    public void setSize(Dimension newSize) {
        if (newSize != null) {
            this.size.setSize(newSize);
            this.firePropertyChange(SIZE_PROP, null, this.size);
        }
    }
}

