/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceData;

public class ClasspathUpdater {
    private final WorkspaceData wsData;
    private Predicate<IProject> predicate;
    private Map<String, IPath> sourcePaths = new HashMap<String, IPath>();

    public ClasspathUpdater(WorkspaceData wsData) {
        this.wsData = wsData;
    }

    public void setPredicate(Predicate<IProject> predicate) {
        this.predicate = predicate;
    }

    public void setSourcePaths(Map<String, IPath> sourcePaths) {
        this.sourcePaths = sourcePaths != null ? sourcePaths : new HashMap();
    }

    public void update(TaskingLog console, IProgressMonitor monitor) {
        console.info("running class-path update");
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor updMon = mon.newChild(70);
        updMon.beginTask("Update classpaths...", this.wsData.getPlugins().size());
        ArrayList<PluginData> refreshList = new ArrayList<PluginData>();
        for (PluginData pd : this.wsData.getPlugins()) {
            updMon.checkCanceled();
            updMon.worked(1);
            String bundleName = pd.getBundleName();
            try {
                IProject project = pd.getProject();
                if (project == null || !JavaProject.hasJavaNature((IProject)project)) {
                    console.warn("skipping " + bundleName);
                    continue;
                }
                if (this.predicate != null && !this.predicate.test(project)) continue;
                IPluginModelBase model = PluginRegistry.findModel((IProject)project);
                if (model == null) {
                    console.warn("skipping " + bundleName);
                    continue;
                }
                IClasspathEntry[] origCP = JavaCore.create((IProject)project).getRawClasspath();
                IClasspathEntry[] freshCP = ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, null, (boolean)true, (boolean)true);
                int i = 0;
                while (i < freshCP.length) {
                    IClasspathEntry old = freshCP[i];
                    if (old.getEntryKind() == 3) {
                        IPath path = old.getPath().removeTrailingSeparator();
                        freshCP[i] = JavaCore.newSourceEntry((IPath)path, (IPath[])old.getInclusionPatterns(), (IPath[])old.getExclusionPatterns(), (IPath)old.getOutputLocation(), (IClasspathAttribute[])old.getExtraAttributes());
                    }
                    ++i;
                }
                Map<IPath, IClasspathEntry> collectedCPofPath = Stream.concat(Stream.of(freshCP), Stream.of(origCP)).collect(Collectors.toMap(e -> ClasspathUpdater.keyOf(e), e -> e, (first, dupe) -> first));
                ArrayList<IClasspathEntry> mergedCP = new ArrayList<IClasspathEntry>();
                IClasspathEntry[] iClasspathEntryArray = origCP;
                int n = origCP.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry orig = iClasspathEntryArray[n2];
                    IClasspathEntry collect = collectedCPofPath.remove(ClasspathUpdater.keyOf(orig));
                    if (collect != null) {
                        IClasspathEntry merged = collect;
                        switch (collect.getEntryKind()) {
                            case 1: {
                                if (collect.getContentKind() != 2) break;
                                IPath source = this.sourcePaths.get(collect.getPath().lastSegment());
                                source = source != null ? source : orig.getSourceAttachmentPath();
                                IPath iPath = source = source != null ? source : collect.getSourceAttachmentPath();
                                if (collect.equals(orig) && Objects.equals(collect.getSourceAttachmentPath(), source)) break;
                                merged = JavaCore.newLibraryEntry((IPath)collect.getPath(), (IPath)source, null, (IAccessRule[])orig.getAccessRules(), (IClasspathAttribute[])orig.getExtraAttributes(), (boolean)orig.isExported());
                                break;
                            }
                            case 3: {
                                merged = orig;
                                break;
                            }
                            case 5: {
                                if (collect.equals(orig)) break;
                                merged = JavaCore.newContainerEntry((IPath)collect.getPath(), (IAccessRule[])orig.getAccessRules(), (IClasspathAttribute[])orig.getExtraAttributes(), (boolean)orig.isExported());
                                break;
                            }
                            case 2: {
                                if (collect.equals(orig)) break;
                                merged = JavaCore.newProjectEntry((IPath)collect.getPath(), (IAccessRule[])orig.getAccessRules(), (boolean)orig.combineAccessRules(), (IClasspathAttribute[])orig.getExtraAttributes(), (boolean)orig.isExported());
                                break;
                            }
                            case 4: {
                                merged = orig;
                            }
                        }
                        mergedCP.add(merged);
                    }
                    ++n2;
                }
                iClasspathEntryArray = freshCP;
                n = freshCP.length;
                n2 = 0;
                while (n2 < n) {
                    IClasspathEntry fresh = iClasspathEntryArray[n2];
                    if (collectedCPofPath.remove(ClasspathUpdater.keyOf(fresh)) != null) {
                        IPath source;
                        if (fresh.getEntryKind() == 1 && fresh.getContentKind() == 2 && (source = this.sourcePaths.get(fresh.getPath().lastSegment())) != null && !source.equals((Object)fresh.getSourceAttachmentPath())) {
                            fresh = JavaCore.newLibraryEntry((IPath)fresh.getPath(), (IPath)source, null, (IAccessRule[])fresh.getAccessRules(), (IClasspathAttribute[])fresh.getExtraAttributes(), (boolean)fresh.isExported());
                        }
                        mergedCP.add(fresh);
                    }
                    ++n2;
                }
                JavaCore.create((IProject)project).setRawClasspath(mergedCP.toArray(new IClasspathEntry[mergedCP.size()]), null);
                refreshList.add(pd);
            }
            catch (Exception ex) {
                console.error("skipped classpath update for " + bundleName + " because of: " + ex);
                ex.printStackTrace(console.warn());
            }
        }
        console.debug("refreshing " + refreshList.size() + " bundles");
        SubMonitor refMon = mon.newChild(30);
        refMon.beginTask("Refreshing plugins...", refreshList.size());
        for (PluginData pd : refreshList) {
            refMon.worked(1);
            pd.refreshProject();
        }
        console.info("update finished");
        if (monitor != null) {
            monitor.done();
        }
    }

    private static IPath keyOf(IClasspathEntry entry) {
        if (PDECore.JRE_CONTAINER_PATH.isPrefixOf(entry.getPath())) {
            return PDECore.JRE_CONTAINER_PATH;
        }
        return entry.getPath();
    }
}

