/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.jar;

import java.io.File;
import java.util.Collection;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.jar.ZipConfig;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.tasks.jar.TaskRunJarExport;
import org.eclipse.tea.library.build.util.FileUtils;

public class TaskRunFeaturePluginJarExport
extends TaskRunJarExport {
    private static final String FEATURE_DIRECTORY = "features";
    protected final String featureName;
    private final boolean composite;

    public TaskRunFeaturePluginJarExport(String featureName) {
        this(featureName, false);
    }

    public TaskRunFeaturePluginJarExport(String featureName, boolean composite) {
        super(composite);
        this.featureName = featureName;
        this.composite = composite;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.featureName + ')';
    }

    @Override
    protected Collection<PluginBuild> getPlugins(WorkspaceBuild wb) {
        FeatureBuild feature = wb.getFeature(this.featureName);
        if (feature == null) {
            throw new IllegalStateException("Cannot find feature " + this.featureName);
        }
        return feature.getIncludedPlugins();
    }

    @Override
    @Execute
    public void run(TaskingLog log, WorkspaceBuild wb, JarManager jarManager, BuildDirectories dirs, TaskProgressTracker tracker, ZipConfig config) throws Exception {
        super.run(log, wb, jarManager, dirs, tracker, config);
        File distFeatureDirectory = new File(dirs.getOutputDirectory(), FEATURE_DIRECTORY);
        if (!this.composite) {
            FileUtils.deleteDirectory(distFeatureDirectory);
        }
        FileUtils.mkdirs(distFeatureDirectory);
        log.info("Features directory: " + distFeatureDirectory);
        FeatureBuild feature = wb.getFeature(this.featureName);
        log.info("execJarCommand: " + feature.getFeatureName());
        TaskRunFeaturePluginJarExport.execJarCached(jarManager, distFeatureDirectory, feature);
    }

    public static String getFeatureJarDirectory() {
        return FEATURE_DIRECTORY;
    }
}

