/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.internal.p2.metadata.expression.parser.LDAPFilterParser;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;

public final class PlatformTriple {
    public final String os;
    public final String ws;
    public final String arch;
    public final String nl;
    public static final PlatformTriple WIN32 = new PlatformTriple("win32", "win32", "x86", "");
    public static final PlatformTriple WIN64 = new PlatformTriple("win32", "win32", "x86_64", "");
    public static final PlatformTriple LINUX32 = new PlatformTriple("linux", "gtk", "x86", "");
    public static final PlatformTriple LINUX64 = new PlatformTriple("linux", "gtk", "x86_64", "");
    private final Map<String, String> map = new TreeMap<String, String>();

    public static PlatformTriple[] getAllPlatforms() {
        return new PlatformTriple[]{WIN32, WIN64, LINUX32, LINUX64};
    }

    private PlatformTriple(String os, String ws, String arch, String nl) {
        this.os = os;
        this.ws = ws;
        this.arch = arch;
        this.nl = nl;
        this.map.put("osgi.os", os);
        this.map.put("osgi.ws", ws);
        this.map.put("osgi.arch", arch);
        this.map.put("osgi.nl", nl);
    }

    public String getFragmentArchSuffix() {
        return "." + this.os + '.' + this.arch;
    }

    public String getFragmentWsSuffix() {
        return "." + this.os + '.' + this.ws + '.' + this.arch;
    }

    public String[] getTarget() {
        return new String[]{this.os, this.ws, this.arch, this.nl};
    }

    public String toString() {
        return "[osgi.os:" + this.os + "] [osgi.ws:" + this.ws + "] [osgi.arch:" + this.arch + "] [osgi.nl:" + this.nl + "]";
    }

    public String toStringBuildPropStyle() {
        return String.valueOf(this.os) + "," + this.ws + "," + this.arch;
    }

    public String toStringCmdLine() {
        return String.valueOf(this.ws) + "." + this.os + "." + this.arch;
    }

    public static String getAllTargetsBuildPropStyle() {
        return String.valueOf(WIN32.toStringBuildPropStyle()) + "&" + WIN64.toStringBuildPropStyle() + "&" + LINUX32.toStringBuildPropStyle() + "&" + LINUX64.toStringBuildPropStyle();
    }

    public static String getAllTargetsCommandLineStyle() {
        return String.valueOf(WIN32.toStringCmdLine()) + "," + WIN64.toStringCmdLine() + "," + LINUX32.toStringCmdLine() + "," + LINUX64.toStringCmdLine();
    }

    public boolean matchFilter(String filter) {
        LDAPFilterParser parser = new LDAPFilterParser(ExpressionFactory.INSTANCE);
        IFilterExpression root = parser.parse(filter);
        boolean match = root.match(this.map);
        return match;
    }
}

