/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.live.internal.model;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.internal.TaskProgressExtendedTracker;
import org.eclipse.tea.core.internal.listeners.TaskingStatusTracker;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.ui.live.internal.Refreshable;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationNode;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationStatusNode;

public class VisualizationTaskNode
implements VisualizationNode,
TaskProgressExtendedTracker.ProgressListener {
    private final String name;
    private final int maxProgress;
    private final Object task;
    private final Refreshable refreshable;
    private IStatus status = Status.OK_STATUS;
    private int currentProgress;
    private long duration = -1L;
    private boolean active;
    private boolean skipped;
    private final List<VisualizationStatusNode> statusNodes = new ArrayList<VisualizationStatusNode>();

    @Inject
    public VisualizationTaskNode(@Named(value="org.eclipse.tea.core.task") Object task, @Named(value="org.eclipse.tea.core.task_work") Integer work, Refreshable refreshable) {
        this.task = task;
        this.refreshable = refreshable;
        this.name = TaskingModel.getTaskName((Object)task);
        this.maxProgress = work;
    }

    public Object getTask() {
        return this.task;
    }

    public void begin(TaskProgressExtendedTracker tracker) {
        tracker.addListener((TaskProgressExtendedTracker.ProgressListener)this);
        this.active = true;
    }

    public void done(TaskProgressExtendedTracker tracker, TaskExecutionContext ctx, TaskingStatusTracker states) {
        tracker.removeListener((TaskProgressExtendedTracker.ProgressListener)this);
        this.active = false;
        this.status = states.getStatus(ctx, this.task);
        this.duration = states.getDuration(ctx, this.task);
        if (this.status.getSeverity() > 0) {
            if (this.status.isMultiStatus()) {
                IStatus[] iStatusArray = this.status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus s = iStatusArray[n2];
                    this.statusNodes.add(new VisualizationStatusNode(s));
                    ++n2;
                }
            } else {
                this.statusNodes.add(new VisualizationStatusNode(this.status));
            }
        }
        this.currentProgress = this.maxProgress;
    }

    public void skip() {
        this.duration = 0L;
        this.skipped = true;
        this.status = Status.CANCEL_STATUS;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public List<VisualizationStatusNode> getStatusNodes() {
        return this.statusNodes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTotalProgress() {
        return this.maxProgress;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public void progressChanged(int currentProgress) {
        if (this.currentProgress == currentProgress) {
            return;
        }
        this.currentProgress = currentProgress;
        this.refreshable.refresh();
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isDone() {
        return this.duration != -1L;
    }
}

