/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.user;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.internal.ClasspathUtil;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.util.internal.ProgressMonitorUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class UserLibraryProviderInstallOperation
extends LibraryProviderOperation {
    @Override
    public void execute(LibraryProviderOperationConfig config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)2);
        try {
            UserLibraryProviderInstallOperationConfig cfg = (UserLibraryProviderInstallOperationConfig)config;
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            for (String libraryName : cfg.getLibraryNames()) {
                entries.add(this.createClasspathEntry(cfg, libraryName));
            }
            IProject project = config.getFacetedProject().getProject();
            ClasspathUtil.addClasspathEntries(project, config.getProjectFacet(), entries);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            try {
                Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)cfg.getProjectFacet());
                prefs = prefs.node("user.library.provider/last.used.libraries");
                prefs = prefs.node(cfg.getProjectFacetVersion().getVersionString());
                String[] stringArray = prefs.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String libraryName = stringArray[n2];
                    prefs.node(libraryName).removeNode();
                    ++n2;
                }
                for (String libraryName : cfg.getLibraryNames()) {
                    prefs.node(libraryName);
                }
                prefs.flush();
            }
            catch (BackingStoreException e) {
                FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)2);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    protected IClasspathEntry createClasspathEntry(UserLibraryProviderInstallOperationConfig config, String libraryName) {
        IPath containerPath = new Path("org.eclipse.jdt.USER_LIBRARY").append(libraryName);
        return JavaCore.newContainerEntry((IPath)containerPath);
    }
}

