/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;

public class Clear
extends ConsoleCommand {
    @Override
    public String getName() {
        return "clear";
    }

    @Override
    public String getHelpShort() {
        return "Removes data from a repository";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nclear                   Clears the entire repository\nclear (<uri>|null)...   Clears the specified context(s)\n";
    }

    public Clear(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }

    @Override
    public void execute(String ... tokens) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.writeUnopenedError();
        } else {
            Resource[] contexts;
            try {
                contexts = Util.getContexts(tokens, 1, repository);
            }
            catch (IllegalArgumentException ioe) {
                this.writeError(ioe.getMessage());
                return;
            }
            this.clear(repository, contexts);
        }
    }

    private void clear(Repository repository, Resource[] contexts) {
        if (contexts.length == 0) {
            this.writeInfo("Clearing repository...");
        } else {
            this.writeInfo("Removing specified contexts...");
        }
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(contexts);
            if (contexts.length == 0) {
                con.clearNamespaces();
            }
        }
        catch (RepositoryReadOnlyException e) {
            try {
                if (LockRemover.tryToRemoveLock(repository, this.consoleIO)) {
                    this.clear(repository, contexts);
                }
                this.writeError("Failed to clear repository", (Exception)((Object)e));
            }
            catch (RepositoryException re) {
                this.writeError("Unable to restart repository", (Exception)((Object)re));
            }
        }
        catch (RepositoryException e) {
            this.writeError("Failed to clear repository", (Exception)((Object)e));
        }
    }
}

