/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.document;

import jakarta.json.JsonException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Optional;
import java.util.stream.Collectors;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.http.media.MediaType;
import no.hasmac.rdf.Rdf;
import no.hasmac.rdf.RdfDataset;
import no.hasmac.rdf.io.error.RdfReaderException;
import no.hasmac.rdf.io.error.UnsupportedContentException;

public final class RdfDocument
implements Document {
    private final MediaType contentType;
    private final RdfDataset dataset;
    private final String profile;
    private URI documentUrl;
    private URI contentUrl;

    private RdfDocument(MediaType type, String profile, RdfDataset dataset) {
        this.contentType = type;
        this.profile = profile;
        this.dataset = dataset;
    }

    public static Document of(RdfDataset dataset) {
        return RdfDocument.of(MediaType.N_QUADS, dataset);
    }

    public static Document of(MediaType contentType, RdfDataset dataset) {
        RdfDocument.assertContentType(contentType);
        if (dataset == null) {
            throw new IllegalArgumentException("RDF dataset cannot be a null.");
        }
        return new RdfDocument(contentType, null, dataset);
    }

    public static RdfDocument of(InputStream is) throws JsonLdError {
        return RdfDocument.of(MediaType.N_QUADS, is);
    }

    public static RdfDocument of(MediaType type, InputStream is) throws JsonLdError {
        RdfDocument.assertContentType(type);
        try {
            RdfDataset dataset = Rdf.createReader(type, is).readDataset();
            return new RdfDocument(type, null, dataset);
        }
        catch (JsonException | IOException | RdfReaderException | UnsupportedContentException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, e);
        }
    }

    public static Document of(Reader reader) throws JsonLdError {
        return RdfDocument.of(MediaType.N_QUADS, reader);
    }

    public static Document of(MediaType type, Reader reader) throws JsonLdError {
        RdfDocument.assertContentType(type);
        try {
            RdfDataset dataset = Rdf.createReader(type, reader).readDataset();
            return new RdfDocument(type, null, dataset);
        }
        catch (JsonException | IOException | RdfReaderException | UnsupportedContentException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, e);
        }
    }

    public static boolean accepts(MediaType contentType) {
        return Rdf.canRead().contains(contentType);
    }

    private static void assertContentType(MediaType contentType) {
        if (!RdfDocument.accepts(contentType)) {
            throw new IllegalArgumentException("Unsupported media type '" + String.valueOf(contentType) + "'. Supported content types are [" + Rdf.canRead().stream().map(MediaType::toString).collect(Collectors.joining(", ")) + "]");
        }
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public URI getContextUrl() {
        return this.contentUrl;
    }

    @Override
    public void setContextUrl(URI contextUrl) {
        this.contentUrl = contextUrl;
    }

    @Override
    public URI getDocumentUrl() {
        return this.documentUrl;
    }

    @Override
    public void setDocumentUrl(URI documentUrl) {
        this.documentUrl = documentUrl;
    }

    @Override
    public Optional<String> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    @Override
    public Optional<RdfDataset> getRdfContent() {
        return Optional.of(this.dataset);
    }
}

