/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class ReflectionUtil {
    public static Object callMethod(Object instance, String name, List<Class<?>> argTypes, List<Object> args, boolean checked) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = instance.getClass();
        Method method = ReflectionUtil.findMethod(clazz, name, argTypes);
        if (method == null) {
            if (checked) {
                throw new NoSuchMethodException(String.format("Clas: $s, method: %s", clazz, name));
            }
            return null;
        }
        method.setAccessible(true);
        try {
            return method.invoke(instance, args.toArray(new Object[args.size()]));
        }
        catch (IllegalAccessException e) {
            if (checked) {
                throw e;
            }
            return null;
        }
        catch (InvocationTargetException e) {
            if (checked) {
                throw e;
            }
            return null;
        }
    }

    public static Object callMethod(Object instance, String name) {
        try {
            return ReflectionUtil.callMethod(instance, name, Collections.emptyList(), Collections.emptyList(), false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getField(Object instance, String name) {
        try {
            return ReflectionUtil.getField(instance, name, false);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Object getField(Object instance, String name, boolean checked) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = instance.getClass();
        Field field = ReflectionUtil.findField(clazz, name);
        if (field == null) {
            if (checked) {
                throw new NoSuchFieldException(String.format("Class: %s, field: %s", clazz, name));
            }
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            if (checked) {
                throw e;
            }
            return null;
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredField(name);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return ReflectionUtil.findField(clazz.getSuperclass(), name);
        }
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtil.findMethod(clazz, name, Collections.emptyList());
    }

    public static Method findMethod(Class<?> clazz, String name, List<Class<?>> params) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(name, params.toArray(new Class[params.size()]));
        }
        catch (NoSuchMethodException e) {
            return ReflectionUtil.findMethod(clazz.getSuperclass(), name, params);
        }
        catch (SecurityException e) {
            return null;
        }
    }
}

