/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.loginDialog.snippets;

import java.util.Locale;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.loginDialog.LoginDialog;
import org.eclipse.nebula.widgets.opal.loginDialog.LoginDialogVerifier;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LoginDialogSnippet {
    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Login dialog snippet");
        shell.setLayout((Layout)new GridLayout(2, false));
        Label label1 = new Label((Composite)shell, 64);
        label1.setText("This is the basic dialog box, \nwithout any customization");
        label1.setLayoutData((Object)new GridData(4, 1, true, false));
        Button button1 = new Button((Composite)shell, 8);
        button1.setText("Open basic dialog");
        button1.setLayoutData((Object)new GridData(4, 1, false, false));
        LoginDialogVerifier verifier = (login, password) -> {
            if ("".equals(login)) {
                throw new Exception("Please enter a login.");
            }
            if ("".equals(password)) {
                throw new Exception("Please enter a password.");
            }
            if (!login.equalsIgnoreCase("laurent")) {
                throw new Exception("Login unknown.");
            }
            if (!password.equalsIgnoreCase("laurent")) {
                throw new Exception("Authentication failed, please check your password.");
            }
        };
        button1.addListener(13, e -> {
            LoginDialog dialog = new LoginDialog();
            dialog.setVerifier(verifier);
            boolean result = dialog.open();
            if (result) {
                System.out.println("Login confirmed : " + dialog.getLogin());
            } else {
                System.out.println("User canceled !");
            }
        });
        Label separator = new Label((Composite)shell, 258);
        separator.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        Label label2 = new Label((Composite)shell, 0);
        label2.setText("This is a customized login (image, description, \ndefault login, multiple login values, \nno button 'remember my password'");
        label2.setLayoutData((Object)new GridData(4, 1, true, false));
        Button button2 = new Button((Composite)shell, 8);
        button2.setText("Open customized dialog");
        button2.setLayoutData((Object)new GridData(3, 1, false, false));
        button2.addListener(13, e -> {
            LoginDialog dialog = new LoginDialog();
            dialog.setImage(new Image((Device)display, LoginDialogSnippet.class.getResourceAsStream("image.png")));
            dialog.setDescription("Please login to our system...\nPlease remember that the password is the same as the login :)");
            dialog.setAutorizedLogin(new String[]{"Laurent", "Albert", "Erik", "Ulrich", "Luis"});
            dialog.setLogin("Laurent");
            dialog.setDisplayRememberPassword(false);
            dialog.setVerifier(verifier);
            boolean result = dialog.open();
            if (result) {
                System.out.println("Login confirmed : " + dialog.getLogin());
            } else {
                System.out.println("User canceled !");
            }
        });
        shell.pack();
        shell.open();
        SWTGraphicUtil.centerShell((Shell)shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

