/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class FormattedTextObservableValue
extends AbstractObservableValue
implements ISWTObservable {
    protected final FormattedText formattedText;
    private final int updateEventType;
    private boolean updating = false;
    private Object oldValue;
    private Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            Object newValue;
            if (!FormattedTextObservableValue.this.updating && ((newValue = FormattedTextObservableValue.this.formattedText.getValue()) == null && FormattedTextObservableValue.this.oldValue != null || newValue != null && !newValue.equals(FormattedTextObservableValue.this.oldValue))) {
                FormattedTextObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)FormattedTextObservableValue.this.oldValue, (Object)newValue));
                FormattedTextObservableValue.this.oldValue = newValue;
            }
        }
    };
    private static final int[] validUpdateEventTypes;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            FormattedTextObservableValue.this.dispose();
        }
    };

    static {
        int[] nArray = new int[3];
        nArray[0] = 24;
        nArray[1] = 16;
        validUpdateEventTypes = nArray;
    }

    public FormattedTextObservableValue(FormattedText formattedText) {
        this(Realm.getDefault(), formattedText, 24);
    }

    public FormattedTextObservableValue(FormattedText formattedText, int updateEventType) {
        this(Realm.getDefault(), formattedText, updateEventType);
    }

    public FormattedTextObservableValue(Realm realm, FormattedText formattedText, int updateEventType) {
        super(realm);
        boolean eventValid = false;
        int i = 0;
        while (!eventValid && i < validUpdateEventTypes.length) {
            eventValid = updateEventType == validUpdateEventTypes[i];
            ++i;
        }
        if (!eventValid) {
            throw new IllegalArgumentException("UpdateEventType [" + updateEventType + "] is not supported.");
        }
        this.formattedText = formattedText;
        this.updateEventType = updateEventType;
        if (updateEventType != 0) {
            formattedText.getControl().addListener(updateEventType, this.updateListener);
        }
        formattedText.getControl().addDisposeListener(this.disposeListener);
    }

    public void dispose() {
        if (this.formattedText.getControl() != null && !this.formattedText.getControl().isDisposed() && this.updateEventType != 0) {
            this.formattedText.getControl().removeListener(this.updateEventType, this.updateListener);
        }
        super.dispose();
    }

    protected Object doGetValue() {
        this.oldValue = this.formattedText.getValue();
        return this.oldValue;
    }

    protected void doSetValue(Object value) {
        try {
            this.updating = true;
            this.formattedText.setValue(value);
            this.oldValue = this.formattedText.getValue();
        }
        finally {
            this.updating = false;
        }
    }

    public Object getValueType() {
        return this.formattedText.getValueType();
    }

    public Widget getWidget() {
        return this.formattedText.getControl();
    }
}

