/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HorizontalSplitPanelImages;
import com.google.gwt.user.client.ui.SplitPanel;
import com.google.gwt.user.client.ui.Widget;

@Deprecated
public final class HorizontalSplitPanel
extends SplitPanel {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private final Element container;
    private final Impl impl = (Impl)GWT.create(Impl.class);
    private String lastSplitPosition = "50%";
    private int initialThumbPos;
    private int initialLeftWidth;

    public HorizontalSplitPanel() {
        this((Resources)GWT.create(Resources.class));
    }

    @Deprecated
    public HorizontalSplitPanel(HorizontalSplitPanelImages images) {
        this(images.horizontalSplitPanelThumb());
    }

    public HorizontalSplitPanel(Resources resources) {
        this(AbstractImagePrototype.create(resources.horizontalSplitPanelThumb()));
    }

    private HorizontalSplitPanel(AbstractImagePrototype thumbImage) {
        super(DOM.createDiv(), DOM.createDiv(), HorizontalSplitPanel.preventBoxStyles(DOM.createDiv()), HorizontalSplitPanel.preventBoxStyles(DOM.createDiv()));
        this.container = HorizontalSplitPanel.preventBoxStyles(DOM.createDiv());
        this.buildDOM(thumbImage);
        this.setStyleName("gwt-HorizontalSplitPanel");
        this.impl.init(this);
        this.setHeight("100%");
    }

    public void add(Widget w) {
        if (this.getStartOfLineWidget() == null) {
            this.setStartOfLineWidget(w);
        } else if (this.getEndOfLineWidget() == null) {
            this.setEndOfLineWidget(w);
        } else {
            throw new IllegalStateException("A Splitter can only contain two Widgets.");
        }
    }

    public Widget getEndOfLineWidget() {
        return this.getWidget(this.getEndOfLinePos());
    }

    public Widget getLeftWidget() {
        return this.getWidget(0);
    }

    public Widget getRightWidget() {
        return this.getWidget(1);
    }

    public Widget getStartOfLineWidget() {
        return this.getWidget(this.getStartOfLinePos());
    }

    public void setEndOfLineWidget(Widget w) {
        this.setWidget(this.getEndOfLinePos(), w);
    }

    public void setLeftWidget(Widget w) {
        this.setWidget(0, w);
    }

    public void setRightWidget(Widget w) {
        this.setWidget(1, w);
    }

    public void setSplitPosition(String pos) {
        this.lastSplitPosition = pos;
        this.impl.setSplitPosition(pos);
    }

    public void setStartOfLineWidget(Widget w) {
        this.setWidget(this.getStartOfLinePos(), w);
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        HorizontalSplitPanel.ensureDebugId(this.getElement(0), baseID, "left");
        HorizontalSplitPanel.ensureDebugId(this.getElement(1), baseID, "right");
    }

    protected void onLoad() {
        this.impl.onAttach();
        this.setSplitPosition(this.lastSplitPosition);
        DeferredCommand.addCommand(new Command(){

            public void execute() {
                HorizontalSplitPanel.this.setSplitPosition(HorizontalSplitPanel.this.lastSplitPosition);
            }
        });
    }

    protected void onUnload() {
        this.impl.onDetach();
    }

    void onSplitterResize(int x, int y) {
        this.impl.onSplitResize(this.initialLeftWidth + x - this.initialThumbPos);
    }

    void onSplitterResizeStarted(int x, int y) {
        this.initialThumbPos = x;
        this.initialLeftWidth = HorizontalSplitPanel.getOffsetWidth(this.getElement(0));
    }

    private void buildDOM(AbstractImagePrototype thumbImage) {
        Element leftDiv = this.getElement(0);
        Element rightDiv = this.getElement(1);
        Element splitDiv = this.getSplitElement();
        DOM.appendChild(this.getElement(), this.container);
        DOM.appendChild(this.container, leftDiv);
        DOM.appendChild(this.container, splitDiv);
        DOM.appendChild(this.container, rightDiv);
        DOM.setInnerHTML(splitDiv, "<table class='hsplitter' height='100%' cellpadding='0' cellspacing='0'><tr><td align='center' valign='middle'>" + thumbImage.getHTML());
        HorizontalSplitPanel.addScrolling(leftDiv);
        HorizontalSplitPanel.addScrolling(rightDiv);
    }

    private int getEndOfLinePos() {
        return LocaleInfo.getCurrentLocale().isRTL() ? 0 : 1;
    }

    private int getStartOfLinePos() {
        return LocaleInfo.getCurrentLocale().isRTL() ? 1 : 0;
    }

    private static class ImplSafari
    extends Impl {
        private ImplSafari() {
        }

        public void init(HorizontalSplitPanel panel) {
            this.panel = panel;
            String fullSize = "100%";
            super.init(panel);
            SplitPanel.setHeight(panel.container, "100%");
            SplitPanel.setHeight(panel.getElement(0), "100%");
            SplitPanel.setHeight(panel.getElement(1), "100%");
            SplitPanel.setHeight(panel.getSplitElement(), "100%");
        }
    }

    private static class ImplIE6
    extends Impl {
        private boolean isResizeInProgress = false;
        private int splitPosition = 0;

        private ImplIE6() {
        }

        public void init(HorizontalSplitPanel panel) {
            this.panel = panel;
            Element elem = panel.getElement();
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                DOM.setStyleAttribute(elem, "textAlign", "right");
            } else {
                DOM.setStyleAttribute(elem, "textAlign", "left");
            }
            DOM.setStyleAttribute(elem, "position", "relative");
            SplitPanel.addAbsolutePositoning(panel.getElement(0));
            SplitPanel.addAbsolutePositoning(panel.getElement(1));
            SplitPanel.addAbsolutePositoning(panel.getSplitElement());
            SplitPanel.expandToFitParentUsingPercentages(panel.container);
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                SplitPanel.setLeft(panel.getElement(0), "0px");
            }
        }

        public void onAttach() {
            this.addResizeListener(this.panel.container);
            this.onResize();
        }

        public void onDetach() {
            DOM.setElementAttribute(this.panel.container, "onresize", null);
        }

        public void onSplitResize(int px) {
            int resizeUpdatePeriod = 20;
            if (!this.isResizeInProgress) {
                this.isResizeInProgress = true;
                new Timer(){

                    public void run() {
                        ImplIE6.this.setSplitPositionUsingPixels(ImplIE6.this.splitPosition);
                        ImplIE6.this.isResizeInProgress = false;
                    }
                }.schedule(20);
            }
            this.splitPosition = px;
        }

        public void setSplitPositionUsingPixels(int px) {
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                int splitElemWidth;
                Element splitElem = this.panel.getSplitElement();
                int rootElemWidth = SplitPanel.getOffsetWidth(this.panel.container);
                if (rootElemWidth < (splitElemWidth = SplitPanel.getOffsetWidth(splitElem))) {
                    return;
                }
                int newRightWidth = rootElemWidth - px - splitElemWidth;
                if (px < 0) {
                    px = 0;
                    newRightWidth = rootElemWidth - splitElemWidth;
                } else if (newRightWidth < 0) {
                    px = rootElemWidth - splitElemWidth;
                    newRightWidth = 0;
                }
                SplitPanel.setWidth(this.panel.getElement(1), newRightWidth + "px");
                SplitPanel.setLeft(splitElem, px + "px");
                if (px == 0) {
                    DeferredCommand.addCommand(new Command(){

                        public void execute() {
                            SplitPanel.setWidth(ImplIE6.this.panel.getElement(0), "0px");
                        }
                    });
                } else {
                    SplitPanel.setWidth(this.panel.getElement(0), px + "px");
                }
            } else {
                super.setSplitPositionUsingPixels(px);
            }
        }

        public void updateRightWidth(Element rightElem, int newRightWidth) {
            SplitPanel.setWidth(rightElem, newRightWidth + "px");
        }

        private native void addResizeListener(Element var1);

        private void onResize() {
            Element leftElem = this.panel.getElement(0);
            Element rightElem = this.panel.getElement(1);
            String height = SplitPanel.getOffsetHeight(this.panel.container) + "px";
            SplitPanel.setHeight(rightElem, height);
            SplitPanel.setHeight(this.panel.getSplitElement(), height);
            SplitPanel.setHeight(leftElem, height);
            this.setSplitPositionUsingPixels(SplitPanel.getOffsetWidth(leftElem));
        }
    }

    private static class Impl {
        protected HorizontalSplitPanel panel;

        private Impl() {
        }

        private static void expandToFitParentHorizontally(Element elem) {
            SplitPanel.addAbsolutePositoning(elem);
            String zeroSize = "0px";
            SplitPanel.setTop(elem, "0px");
            SplitPanel.setBottom(elem, "0px");
        }

        public void init(HorizontalSplitPanel panel) {
            this.panel = panel;
            DOM.setStyleAttribute(panel.getElement(), "position", "relative");
            Impl.expandToFitParentHorizontally(panel.getElement(0));
            Impl.expandToFitParentHorizontally(panel.getElement(1));
            Impl.expandToFitParentHorizontally(panel.getSplitElement());
            SplitPanel.expandToFitParentUsingCssOffsets(panel.container);
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                SplitPanel.setLeft(panel.getElement(0), "0px");
            } else {
                SplitPanel.setRight(panel.getElement(1), "0px");
            }
        }

        public void onAttach() {
        }

        public void onDetach() {
        }

        public void onSplitResize(int px) {
            this.setSplitPositionUsingPixels(px);
        }

        public void setSplitPosition(String pos) {
            Element leftElem = this.panel.getElement(0);
            SplitPanel.setWidth(leftElem, pos);
            this.setSplitPositionUsingPixels(SplitPanel.getOffsetWidth(leftElem));
        }

        public void setSplitPositionUsingPixels(int px) {
            int splitElemWidth;
            Element splitElem = this.panel.getSplitElement();
            int rootElemWidth = SplitPanel.getOffsetWidth(this.panel.container);
            if (rootElemWidth < (splitElemWidth = SplitPanel.getOffsetWidth(splitElem))) {
                return;
            }
            int newRightWidth = rootElemWidth - px - splitElemWidth;
            if (px < 0) {
                px = 0;
                newRightWidth = rootElemWidth - splitElemWidth;
            } else if (newRightWidth < 0) {
                px = rootElemWidth - splitElemWidth;
                newRightWidth = 0;
            }
            Element rightElem = this.panel.getElement(1);
            SplitPanel.setWidth(this.panel.getElement(0), px + "px");
            SplitPanel.setLeft(splitElem, px + "px");
            SplitPanel.setLeft(rightElem, px + splitElemWidth + "px");
            this.updateRightWidth(rightElem, newRightWidth);
        }

        public void updateRightWidth(Element rightElem, int newRightWidth) {
        }
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"splitPanelThumb.png"})
        public ImageResource horizontalSplitPanelThumb();
    }
}

