/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.elementselection;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractElementSelectionInput;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionService;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionServiceJob;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionListener;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionProvider;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEventType;
import org.eclipse.gmf.runtime.common.ui.services.internal.l10n.CommonUIServicesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public abstract class ElementSelectionComposite
implements IElementSelectionListener {
    private final String title;
    private final List selectedElements = new ArrayList();
    private Text filterText = null;
    private TableViewer tableViewer = null;
    private ProgressMonitorPart progressBar;
    private AbstractElementSelectionInput input;
    private ElementSelectionServiceJob job;
    private final ElementSelectionService elementSelectionService;
    private char firstCharacter = '\u0000';
    private String lastSearchedFor = "";
    private int lastScopeSearchedFor = 0;
    private List matchingObjects = new ArrayList();
    private Pattern pattern;

    public ElementSelectionComposite(String title, AbstractElementSelectionInput input) {
        this(title, input, ElementSelectionService.getInstance());
    }

    public ElementSelectionComposite(String title, AbstractElementSelectionInput input, ElementSelectionService elementSelectionService) {
        this.title = title;
        this.input = input;
        this.elementSelectionService = elementSelectionService;
        this.lastScopeSearchedFor = input.getScope().intValue();
    }

    protected abstract boolean isValidSelection(List var1);

    protected abstract void handleSelection(boolean var1);

    public Composite createComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout());
        result.setLayoutData((Object)new GridData(1808));
        Label label = new Label(result, 0);
        label.setText(this.title);
        this.filterText = new Text(result, 2052);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ElementSelectionComposite.this.handleFilterChange();
            }
        });
        int selectStyle = 4;
        this.tableViewer = new TableViewer(result, selectStyle | 0x100 | 0x200 | 0x800);
        this.tableViewer.setUseHashlookup(true);
        Table table = this.tableViewer.getTable();
        GridData gridData = new GridData(1808);
        GC gc = new GC((Drawable)result);
        gc.setFont(JFaceResources.getDefaultFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)80);
        gridData.heightHint = table.getItemHeight() * 15;
        table.setLayoutData((Object)gridData);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementSelectionComposite.this.handleSelectionChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ElementSelectionComposite.this.handleWidgetDefaultSelected();
            }
        });
        this.progressBar = new ProgressMonitorPart(result, (Layout)new GridLayout());
        this.progressBar.setLayoutData((Object)new GridData(768));
        this.progressBar.setVisible(false);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (!$assertionsDisabled && !(element instanceof AbstractMatchingObject)) {
                    throw new AssertionError();
                }
                return ((AbstractMatchingObject)element).getImage();
            }

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof AbstractMatchingObject)) {
                    throw new AssertionError();
                }
                return ((AbstractMatchingObject)element).getDisplayName();
            }
        });
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IMatchingObject && e2 instanceof IMatchingObject) {
                    return ((IMatchingObject)e1).getName().toLowerCase().compareTo(((IMatchingObject)e2).getName().toLowerCase());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.createCompositeAdditions(result);
        return result;
    }

    protected void createCompositeAdditions(Composite parent) {
    }

    public void handleFilterChange() {
        if (this.filterText.getText().equals("")) {
            this.cancel();
            this.matchingObjects.clear();
            this.tableViewer.getTable().removeAll();
            this.firstCharacter = '\u0000';
            return;
        }
        String filter = this.validatePattern(this.filterText.getText());
        this.pattern = Pattern.compile(filter);
        if (this.firstCharacter != this.filterText.getText().charAt(0) || this.input.getScope().intValue() != this.lastScopeSearchedFor || !this.filterText.getText().startsWith(this.lastSearchedFor)) {
            this.cancel();
            this.matchingObjects.clear();
            this.tableViewer.getTable().removeAll();
            this.firstCharacter = this.filterText.getText().charAt(0);
            this.lastScopeSearchedFor = this.input.getScope().intValue();
            this.startElementSelectionService();
        } else {
            this.tableViewer.getTable().removeAll();
            for (IMatchingObject matchingObject : this.matchingObjects) {
                Matcher matcher = this.pattern.matcher(matchingObject.getName().toLowerCase());
                if (!matcher.matches()) continue;
                this.tableViewer.add((Object)matchingObject);
                this.setSelection();
            }
        }
    }

    private void startElementSelectionService() {
        this.input.setInput(this.filterText.getText());
        this.lastSearchedFor = this.filterText.getText();
        this.progressBar.setVisible(true);
        this.progressBar.beginTask(CommonUIServicesMessages.ElementSelectionService_ProgressName, -1);
        this.job = this.elementSelectionService.getMatchingObjects(this.input, this);
    }

    private void handleSelectionChange() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection.size() == 0) {
            this.selectedElements.clear();
            this.handleSelection(false);
            return;
        }
        List selectionList = selection.toList();
        ArrayList<AbstractMatchingObject> currentSelectedElements = new ArrayList<AbstractMatchingObject>();
        for (AbstractMatchingObject matchingObject : selectionList) {
            currentSelectedElements.add(matchingObject);
        }
        boolean isValidSelection = this.isValidSelection(currentSelectedElements);
        this.selectedElements.clear();
        if (isValidSelection) {
            this.selectedElements.addAll(currentSelectedElements);
        }
        this.handleSelection(isValidSelection);
    }

    public List getSelectedElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (IMatchingObject matchingObject : this.selectedElements) {
            IElementSelectionProvider provider = matchingObject.getProvider();
            Object object = provider.resolve(matchingObject);
            result.add(object);
        }
        return result;
    }

    @Override
    public void matchingObjectEvent(IMatchingObjectEvent matchingObjectEvent) {
        if (!this.progressBar.isDisposed()) {
            if (matchingObjectEvent.getEventType() == MatchingObjectEventType.END_OF_MATCHES) {
                this.progressBar.done();
                this.progressBar.setVisible(false);
                this.job = null;
            } else {
                IMatchingObject matchingObject = matchingObjectEvent.getMatchingObject();
                this.progressBar.worked(1);
                this.progressBar.subTask(matchingObject.getName());
                this.matchingObjects.add(matchingObject);
                Matcher matcher = this.pattern.matcher(matchingObject.getName().toLowerCase());
                if (matcher.matches()) {
                    this.tableViewer.add((Object)matchingObject);
                    this.setSelection();
                }
            }
        }
    }

    public void cancel() {
        if (this.job != null) {
            this.elementSelectionService.cancelJob(this.job);
            this.job = null;
            this.progressBar.done();
            this.progressBar.setVisible(false);
        }
    }

    private String validatePattern(String string) {
        if (string.equals("")) {
            return string;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char c = Character.toLowerCase(string.charAt(i));
            if (c == '?') {
                result.append('.');
            } else if (c == '*') {
                result.append(".*");
            } else {
                result.append(c);
            }
            ++i;
        }
        result.append(".*");
        return result.toString();
    }

    protected void setSelection() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            this.tableViewer.getTable().setSelection(0);
            this.handleSelectionChange();
        }
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public ElementSelectionServiceJob getSelectionServiceJob() {
        return this.job;
    }

    protected void handleWidgetDefaultSelected() {
    }
}

