/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.clipboard;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public abstract class DiagramGenerator {
    private int image_margin = 0;
    private DiagramEditPart _dgrmEP;

    public DiagramGenerator(DiagramEditPart dgrmEP) {
        this._dgrmEP = dgrmEP;
        this.image_margin = this.getMapMode().DPtoLP(10);
    }

    protected DiagramEditPart getDiagramEditPart() {
        return this._dgrmEP;
    }

    protected abstract Graphics setUpGraphics(int var1, int var2);

    protected void disposeGraphics(Graphics g) {
        g.dispose();
    }

    protected abstract ImageDescriptor getImageDescriptor(Graphics var1);

    public final Image createAWTImageForDiagram() {
        List editparts = this.getDiagramEditPart().getPrimaryEditParts();
        return this.createAWTImageForParts(editparts);
    }

    public abstract Image createAWTImageForParts(List var1);

    public final ImageDescriptor createSWTImageDescriptorForDiagram() {
        List editparts = this.getDiagramEditPart().getPrimaryEditParts();
        return this.createSWTImageDescriptorForParts(editparts);
    }

    public final ImageDescriptor createSWTImageDescriptorForParts(List editparts) {
        org.eclipse.swt.graphics.Rectangle sourceRect = this.calculateImageRectangle(editparts);
        ImageDescriptor imageDesc = new ImageDescriptor(){

            public ImageData getImageData() {
                return SharedImages.get((String)"icons/error.gif").getImageData();
            }
        };
        Graphics graphics = null;
        try {
            IMapMode mm = this.getMapMode();
            graphics = this.setUpGraphics(mm.LPtoDP(sourceRect.width), mm.LPtoDP(sourceRect.height));
            RenderedMapModeGraphics mapModeGraphics = new RenderedMapModeGraphics(graphics, this.getMapMode());
            this.renderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), editparts);
            imageDesc = this.getImageDescriptor(graphics);
        }
        catch (Error e) {
            Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, this.getClass(), (String)"createSWTImageDescriptorForParts() failed to generate image", (Throwable)e);
        }
        catch (Exception ex) {
            Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, this.getClass(), (String)"createSWTImageDescriptorForParts() failed to generate image", (Throwable)ex);
        }
        if (graphics != null) {
            this.disposeGraphics(graphics);
        }
        return imageDesc;
    }

    protected IMapMode getMapMode() {
        IMapMode mm = MapModeUtil.getMapMode((IFigure)this.getDiagramEditPart().getFigure());
        return mm;
    }

    protected final void renderToGraphics(Graphics graphics, Point translateOffset, List editparts) {
        IGraphicalEditPart editPart;
        List sortedEditparts = this.sortSelection(editparts);
        graphics.translate(-translateOffset.x, -translateOffset.y);
        graphics.pushState();
        ArrayList<IGraphicalEditPart> connectionsToPaint = new ArrayList<IGraphicalEditPart>();
        Map decorations = this.findDecorations(editparts);
        int i = 0;
        while (i < editparts.size()) {
            editPart = (IGraphicalEditPart)sortedEditparts.get(i);
            if (editPart instanceof ConnectionNodeEditPart) {
                connectionsToPaint.add(editPart);
            } else {
                ArrayList editParts = new ArrayList();
                this.getNestedEditParts(editPart, editParts);
                this.findConnectionsToPaint(editParts, connectionsToPaint);
                IFigure figure = editPart.getFigure();
                this.paintFigure(graphics, figure);
                this.paintDecorations(graphics, figure, decorations);
            }
            ++i;
        }
        decorations = this.findDecorations(connectionsToPaint);
        i = 0;
        while (i < connectionsToPaint.size()) {
            editPart = (IGraphicalEditPart)connectionsToPaint.get(i);
            IFigure figure = editPart.getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
            ++i;
        }
    }

    private void paintFigure(Graphics graphics, IFigure figure) {
        if (!figure.isVisible()) {
            return;
        }
        Rectangle relBounds = null;
        relBounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
        Rectangle abBounds = relBounds.getCopy();
        this.translateToPrintableLayer(figure, (Translatable)abBounds);
        int transX = abBounds.x - relBounds.x;
        int transY = abBounds.y - relBounds.y;
        graphics.pushState();
        graphics.translate(transX, transY);
        figure.paint(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    private Map findDecorations(List editparts) {
        IGraphicalEditPart first;
        IFigure decorationLayer;
        Map figureMap = this.mapFiguresToEditParts(editparts);
        HashMap<IFigure, Object> result = new HashMap<IFigure, Object>();
        if (!editparts.isEmpty() && (decorationLayer = LayerManager.Helper.find((EditPart)(first = (IGraphicalEditPart)editparts.get(0))).getLayer((Object)"Decoration Printable Layer")) != null) {
            ArrayList figures = new ArrayList(editparts);
            Iterator iter = figures.listIterator();
            while (iter.hasNext()) {
                iter.set(((IGraphicalEditPart)iter.next()).getFigure());
            }
            for (Object next : decorationLayer.getChildren()) {
                Decoration decoration;
                IFigure owner;
                if (!(next instanceof Decoration) || !figureMap.containsKey(owner = (decoration = (Decoration)next).getOwnerFigure())) continue;
                Object existing = result.get(owner);
                if (existing == null) {
                    result.put(owner, decoration);
                    continue;
                }
                if (existing instanceof Collection) {
                    ((Collection)existing).add(decoration);
                    continue;
                }
                ArrayList<Object> c = new ArrayList<Object>(2);
                c.add(existing);
                c.add(decoration);
                result.put(owner, c);
            }
        }
        return result;
    }

    private Map mapFiguresToEditParts(Collection editParts) {
        HashMap<IFigure, IGraphicalEditPart> result = new HashMap<IFigure, IGraphicalEditPart>();
        for (IGraphicalEditPart next : editParts) {
            result.put(next.getFigure(), next);
        }
        return result;
    }

    private void paintDecorations(Graphics graphics, IFigure figure, Map decorations) {
        Object decoration = decorations.get(figure);
        if (decoration != null) {
            if (decoration instanceof Collection) {
                Iterator iter = ((Collection)decoration).iterator();
                while (iter.hasNext()) {
                    this.paintFigure(graphics, (IFigure)iter.next());
                }
            } else {
                this.paintFigure(graphics, (IFigure)decoration);
            }
        }
    }

    private void sortSelection(GraphicalEditPart editPart, List open, List closed) {
        if (open.isEmpty()) {
            return;
        }
        if (open.contains(editPart)) {
            closed.add(editPart);
            open.remove(editPart);
        }
        for (GraphicalEditPart child : editPart.getChildren()) {
            this.sortSelection(child, open, closed);
        }
    }

    private List sortSelection(List toSort) {
        ArrayList closed = new ArrayList(toSort.size());
        ArrayList open = new ArrayList(toSort.size());
        open.addAll(toSort);
        this.sortSelection((GraphicalEditPart)this.getDiagramEditPart(), open, closed);
        if (!open.isEmpty()) {
            closed.addAll(open);
        }
        return closed;
    }

    private void getNestedEditParts(IGraphicalEditPart childEditPart, List editParts) {
        for (IGraphicalEditPart child : childEditPart.getChildren()) {
            editParts.add(child);
            this.getNestedEditParts(child, editParts);
        }
    }

    private void findConnectionsToPaint(List editParts, List connectionsToPaint) {
        EditPartViewer viewer = this.getDiagramEditPart().getRoot().getViewer();
        for (IGraphicalEditPart element : editParts) {
            View view = (View)element.getModel();
            if (!(element instanceof ShapeEditPart)) continue;
            EList sourceConnections = view.getSourceEdges();
            int i = 0;
            while (i < sourceConnections.size()) {
                Edge edge = (Edge)sourceConnections.get(i);
                View toView = edge.getTarget();
                AbstractEditPart toEditPart = (AbstractEditPart)viewer.getEditPartRegistry().get(toView);
                if (editParts.contains(toEditPart)) {
                    ConnectionNodeEditPart connectionEditPart = (ConnectionNodeEditPart)viewer.getEditPartRegistry().get(edge);
                    connectionsToPaint.add(connectionEditPart);
                }
                ++i;
            }
        }
    }

    protected org.eclipse.swt.graphics.Rectangle calculateImageRectangle(List editparts) {
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        IMapMode mm = this.getMapMode();
        int i = 0;
        while (i < editparts.size()) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)editparts.get(i);
            IFigure figure = editPart.getFigure();
            Rectangle bounds = null;
            bounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds() : figure.getBounds().getCopy();
            this.translateToPrintableLayer(figure, (Translatable)bounds);
            bounds = bounds.getExpanded(this.getImageMargin(), this.getImageMargin());
            if (i == 0) {
                minX = bounds.x;
                maxX = bounds.x + bounds.width;
                minY = bounds.y;
                maxY = bounds.y + bounds.height;
            } else {
                minX = Math.min(minX, bounds.x);
                maxX = Math.max(maxX, bounds.x + bounds.width);
                minY = Math.min(minY, bounds.y);
                maxY = Math.max(maxY, bounds.y + bounds.height);
            }
            ++i;
        }
        int width = maxX - minX;
        int height = maxY - minY;
        if (width <= 0) {
            width = mm.DPtoLP(100);
        }
        if (height <= 0) {
            height = mm.DPtoLP(100);
        }
        org.eclipse.swt.graphics.Rectangle imageRect = new org.eclipse.swt.graphics.Rectangle(minX, minY, width, height);
        return imageRect;
    }

    public List getDiagramPartInfo(DiagramEditPart diagramEditPart) {
        ArrayList<PartPositionInfo> result = new ArrayList<PartPositionInfo>();
        ArrayList editParts = new ArrayList();
        List children = diagramEditPart.getPrimaryEditParts();
        IMapMode mm = this.getMapMode();
        org.eclipse.swt.graphics.Rectangle imageRect = this.calculateImageRectangle(children);
        for (IGraphicalEditPart part : children) {
            this.getNestedEditParts(part, editParts);
        }
        for (IGraphicalEditPart part : editParts) {
            PartPositionInfo position;
            IFigure figure = part.getFigure();
            if (part instanceof ShapeEditPart || part instanceof ShapeCompartmentEditPart) {
                position = new PartPositionInfo();
                position.setSemanticElement(ViewUtil.resolveSemanticElement((View)((View)part.getModel())));
                Rectangle bounds = figure.getBounds().getCopy();
                this.translateToPrintableLayer(figure, (Translatable)bounds);
                bounds.translate(-imageRect.x, -imageRect.y);
                position.setPartHeight(mm.LPtoDP(bounds.height));
                position.setPartWidth(mm.LPtoDP(bounds.width));
                position.setPartX(mm.LPtoDP(bounds.x));
                position.setPartY(mm.LPtoDP(bounds.y));
                result.add(0, position);
                continue;
            }
            if (!(part instanceof ConnectionEditPart)) continue;
            position = new PartPositionInfo();
            position.setSemanticElement(ViewUtil.resolveSemanticElement((View)((View)part.getModel())));
            if (!(figure instanceof PolylineConnection)) continue;
            PolylineConnection mainPoly = (PolylineConnection)figure;
            PointList mainPts = mainPoly.getPoints();
            this.translateToPrintableLayer(figure, (Translatable)mainPts);
            List envelopingPts = this.calculateEnvelopingPolyline(mainPts, new Point(imageRect.x, imageRect.y));
            List transformedPts = this.convertPolylineUnits(envelopingPts);
            position.setPolyline(transformedPts);
            result.add(0, position);
        }
        return result;
    }

    private void translateToPrintableLayer(IFigure figure, Translatable translatable) {
        IFigure printableLayer = this.getDiagramEditPart().getLayer((Object)"Printable Layers");
        if (figure == null || figure.equals(printableLayer)) {
            return;
        }
        figure.translateToParent(translatable);
        this.translateToPrintableLayer(figure.getParent(), translatable);
    }

    private List calculateEnvelopingPolyline(PointList polyPts, Point origin) {
        ArrayList<Object> result = new ArrayList<Object>();
        List mainSegs = PointListUtilities.getLineSegments((PointList)polyPts);
        int mainSegsLength = mainSegs.size();
        LineSeg segment = null;
        Point orthoPoint1 = null;
        Point orthoPoint2 = null;
        int i = 0;
        while (i < mainSegsLength) {
            segment = (LineSeg)mainSegs.get(i);
            orthoPoint1 = segment.locatePoint(0.0, (long)this.getImageMargin(), LineSeg.Sign.POSITIVE);
            orthoPoint1.translate(-origin.x, -origin.y);
            orthoPoint2 = segment.locatePoint(1.0, (long)this.getImageMargin(), LineSeg.Sign.POSITIVE);
            orthoPoint2.translate(-origin.x, -origin.y);
            result.add(orthoPoint1);
            result.add(orthoPoint2);
            ++i;
        }
        i = mainSegsLength - 1;
        while (i >= 0) {
            segment = (LineSeg)mainSegs.get(i);
            orthoPoint1 = segment.getTerminus();
            orthoPoint1.translate(-origin.x, -origin.y);
            result.add(orthoPoint1);
            orthoPoint2 = segment.getOrigin();
            orthoPoint2.translate(-origin.x, -origin.y);
            result.add(orthoPoint2);
            --i;
        }
        Object first = result.get(0);
        result.add(first);
        return result;
    }

    private List convertPolylineUnits(List polyPts) {
        ArrayList<Point> result = new ArrayList<Point>();
        Iterator iter = polyPts.iterator();
        IMapMode mm = this.getMapMode();
        while (iter.hasNext()) {
            Point point = (Point)iter.next();
            Point newPoint = new Point(mm.LPtoDP(point.x), mm.LPtoDP(point.y));
            result.add(newPoint);
        }
        return result;
    }

    protected int getImageMargin() {
        return this.image_margin;
    }
}

