/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.InternalTransformationExecutor;
import org.eclipse.m2m.internal.qvt.oml.ModelExtentHelper;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationRunner {
    private final URI fTransformationURI;
    private final Executor fExecutor;
    private final List<URI> fModelParamURIs;
    private URI fTraceFileURI;
    private BasicDiagnostic fDiagnostic;
    private List<ModelExtent> fModelParams;
    private ModelExtentHelper fExtentHelper;

    public TransformationRunner(URI transformationURI, EPackage.Registry packageRegistry, List<URI> modelParamURIs) {
        if (transformationURI == null || modelParamURIs == null || modelParamURIs.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.fExecutor = new Executor(transformationURI, packageRegistry);
        this.fTransformationURI = transformationURI;
        this.fModelParamURIs = modelParamURIs;
    }

    protected InternalTransformationExecutor getExecutor() {
        return this.fExecutor;
    }

    public URI getTransformationURI() {
        return this.fTransformationURI;
    }

    public void setTraceFile(URI traceFileURI) {
        this.fTraceFileURI = traceFileURI;
    }

    public URI getTraceFileURI() {
        return this.fTraceFileURI;
    }

    public Diagnostic initialize() {
        if (this.fDiagnostic != null) {
            return this.fDiagnostic;
        }
        this.fDiagnostic = QvtPlugin.createDiagnostic("Transformation runner initiliaze");
        Diagnostic loadDiagnostic = this.fExecutor.loadTransformation();
        if (!QvtPlugin.isSuccess(loadDiagnostic)) {
            this.fDiagnostic.add(loadDiagnostic);
        }
        this.handleLoadTransformation(loadDiagnostic);
        OperationalTransformation transformation = this.fExecutor.getTransformation();
        if (transformation == null) {
            return this.fDiagnostic;
        }
        this.fExtentHelper = new ModelExtentHelper(transformation, this.fModelParamURIs, this.fExecutor.getResourceSet());
        Diagnostic extentsDiagnostic = Diagnostic.OK_INSTANCE;
        try {
            this.fModelParams = this.fExtentHelper.loadExtents();
        }
        catch (DiagnosticException e) {
            extentsDiagnostic = e.getDiagnostic();
        }
        this.handleLoadExtents(extentsDiagnostic);
        if (!QvtPlugin.isSuccess(extentsDiagnostic)) {
            this.fDiagnostic.add(extentsDiagnostic);
        }
        return this.fDiagnostic;
    }

    protected QvtOperationalEnvFactory getEnvFactory() {
        return new QvtOperationalEnvFactory();
    }

    protected void handleLoadTransformation(Diagnostic diagnostic) {
    }

    protected void handleLoadExtents(Diagnostic diagnostic) {
    }

    protected void handleExecution(ExecutionDiagnostic execDiagnostic) {
    }

    protected void handleSaveExtents(Diagnostic diagnostic) {
    }

    public Diagnostic execute(ExecutionContext context) {
        Diagnostic diagnostic = this.initialize();
        if (!TransformationRunner.isSuccess(diagnostic)) {
            return diagnostic;
        }
        this.fExecutor.setEnvironmentFactory(this.getEnvFactory());
        try {
            ModelExtent[] params = this.fModelParams.toArray(new ModelExtent[this.fModelParams.size()]);
            ExecutionDiagnostic execDiagnostic = this.fExecutor.execute(context, params);
            this.handleExecution(execDiagnostic);
            Trace traces = this.fExecutor.fTraces;
            this.fExecutor.fTraces = null;
            if (!TransformationRunner.isSuccess(execDiagnostic)) {
                ExecutionDiagnostic executionDiagnostic = execDiagnostic;
                return executionDiagnostic;
            }
            Diagnostic saveExtentsDiagnostic = this.fExtentHelper.saveExtents();
            this.handleSaveExtents(saveExtentsDiagnostic);
            if (!TransformationRunner.isSuccess(saveExtentsDiagnostic)) {
                Diagnostic diagnostic2 = saveExtentsDiagnostic;
                return diagnostic2;
            }
            Diagnostic saveTracesDiagnostic = this.saveTraces(traces);
            if (!TransformationRunner.isSuccess(saveTracesDiagnostic)) {
                Diagnostic diagnostic3 = saveTracesDiagnostic;
                return diagnostic3;
            }
            ExecutionDiagnostic executionDiagnostic = execDiagnostic;
            return executionDiagnostic;
        }
        finally {
            this.fExecutor.cleanup();
        }
    }

    private Diagnostic saveTraces(Trace trace) {
        if (this.fTraceFileURI != null) {
            Resource resource = new ResourceSetImpl().createResource(this.fTraceFileURI);
            resource.getContents().add((Object)trace);
            try {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("PROCESS_DANGLING_HREF", "DISCARD");
                resource.save(options);
            }
            catch (IOException e) {
                String message = NLS.bind("Failed to save trace model uri={0}", this.fTraceFileURI);
                return new BasicDiagnostic(4, "org.eclipse.m2m.qvt.oml", 0, message, new Object[]{e});
            }
        }
        return Diagnostic.OK_INSTANCE;
    }

    private static boolean isSuccess(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        return severity != 4 && severity != 8;
    }

    protected static class Executor
    extends InternalTransformationExecutor {
        Trace fTraces;

        public Executor(URI uri, EPackage.Registry registry) {
            super(uri, registry);
        }

        public Executor(URI uri) {
            super(uri);
        }

        protected void handleExecutionTraces(Trace traces) {
            super.handleExecutionTraces(traces);
            this.fTraces = traces;
        }
    }
}

