/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvt.environment;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.parser.environment.CSTRootEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.environment.IQVTFileEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.environment.IQVTNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.environment.QVTFormattingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QVTTopLevelEnvironment<E extends IQVTNodeEnvironment, CST extends CSTNode>
extends CSTRootEnvironment<E, CST>
implements IQVTNodeEnvironment {
    private final EPackage.Registry qvtRegistry;
    protected QVTFormattingHelper formatter;

    protected QVTTopLevelEnvironment(IQVTFileEnvironment parent, XMIResource astResource, CST cstNode) {
        super(parent, astResource, cstNode);
        this.qvtRegistry = parent.getRegistry();
    }

    protected void addPackage(EPackage ePackage) {
        ((XMIResource)this.ast).getContents().add((Object)ePackage);
        this.qvtRegistry.put((Object)ePackage.getName(), (Object)ePackage);
        this.getFileEnvironment().initializePackageNs(ePackage);
    }

    protected void addSubPackage(EPackage ePackage, EPackage childPackage) {
        ePackage.getESubpackages().add((Object)childPackage);
        this.getFileEnvironment().initializePackageNs(childPackage);
    }

    @Override
    protected QVTFormattingHelper createFormatter() {
        return new QVTFormattingHelper(this);
    }

    @Override
    public QVTFormattingHelper getFormatter() {
        if (this.formatter == null) {
            this.formatter = this.createFormatter();
        }
        return this.formatter;
    }

    @Override
    public String getModelName(EObject object) {
        return null;
    }

    @Override
    public Transformation getTransformation() {
        return null;
    }

    @Override
    public Variable lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> params) {
        return (Variable)super.lookupImplicitSourceForOperation(name, params);
    }

    @Override
    public Variable lookupImplicitSourceForProperty(String name) {
        return (Variable)super.lookupImplicitSourceForProperty(name);
    }

    public EClass lookupImportedClass(String name) {
        for (Map.Entry entry : this.qvtRegistry.entrySet()) {
            EPackage ePackage = (EPackage)entry.getValue();
            EClassifier eClassifier = ePackage.getEClassifier(name);
            if (!(eClassifier instanceof EClass)) continue;
            return (EClass)eClassifier;
        }
        return null;
    }

    public EClassifier lookupImportedClassifier(String name) {
        for (Map.Entry entry : this.qvtRegistry.entrySet()) {
            EPackage ePackage = (EPackage)entry.getValue();
            EClassifier eClassifier = ePackage.getEClassifier(name);
            if (eClassifier == null) continue;
            return eClassifier;
        }
        return null;
    }

    @Override
    public Transformation lookupImportedTransformation(String name) {
        for (Map.Entry entry : this.qvtRegistry.entrySet()) {
            EPackage ePackage = (EPackage)entry.getValue();
            EClassifier eClassifier = ePackage.getEClassifier(name);
            if (!(eClassifier instanceof Transformation)) continue;
            return (Transformation)eClassifier;
        }
        return null;
    }

    protected String resolveSynonym(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        if ("+".equals(name) && args.size() == 1) {
            EClassifier oclString = (EClassifier)this.getOCLStandardLibrary().getString();
            EClassifier ownerType = (EClassifier)this.getTypeResolver().resolve((Object)owner);
            EClassifier argType = (EClassifier)this.getTypeResolver().resolve((Object)((EClassifier)args.get(0).getType()));
            if (ownerType == oclString && argType == oclString) {
                name = "concat";
            }
        }
        return name;
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        return null;
    }

    public EOperation tryLookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        name = this.resolveSynonym(owner, name, args);
        return (EOperation)super.tryLookupOperation((Object)owner, name, args);
    }

    @Override
    public EReference tryLookupOppositeProperty(EClass eClass, String propertyName) throws LookupException {
        return null;
    }

    @Override
    public Transformation tryLookupTransformation(List<String> pathName) throws LookupException {
        EPackage ePackage = (EPackage)this.tryLookupPackage(pathName);
        if (ePackage == null) {
            return null;
        }
        if (ePackage instanceof Transformation) {
            return (Transformation)ePackage;
        }
        throw new LookupException("Not a transformation", Collections.singletonList(ePackage));
    }

    @Override
    public Variable tryLookupVariable(String name) throws LookupException {
        return null;
    }
}

