/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtrelation.environment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.QVTRelationFactory;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.AbstractQVTrAnalyzer;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.AbstractDomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.DomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.PrimitiveTypeDomainCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.RelationCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrDomainEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTransformationEnvironment;
import org.eclipse.qvt.declarative.parser.utils.OCLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTrRelationEnvironment
extends QVTrEnvironment<QVTrTransformationEnvironment, Relation, RelationCS> {
    private Map<AbstractDomainCS, QVTrDomainEnvironment> domEnvMap = new HashMap<AbstractDomainCS, QVTrDomainEnvironment>();
    private final Map<String, Variable> explicitVariableMap = new HashMap<String, Variable>();
    private final Map<String, List<ImplicitVariable>> implicitVariableMap = new HashMap<String, List<ImplicitVariable>>();

    public QVTrRelationEnvironment(QVTrTransformationEnvironment env, RelationCS relationCS) {
        super(env, QVTRelationFactory.eINSTANCE.createRelation(), relationCS);
        QVTrRelationEnvironment.setNameFromIdentifier((ENamedElement)((ENamedElement)this.ast), (IdentifierCS)relationCS.getIdentifier());
        for (Domain domain : ((Relation)this.ast).getDomain()) {
            Variable rootVariable = ((RelationDomain)domain).getRootVariable();
            String rootVariableName = rootVariable.getName();
            if (rootVariableName == null) continue;
            this.addElement(rootVariableName, (org.eclipse.ocl.expressions.Variable)rootVariable, true);
            this.explicitVariableMap.put(rootVariableName, rootVariable);
        }
    }

    private void addExplicitVariable(Variable variable) {
        ((Relation)this.ast).getVariable().add((Object)variable);
        this.addElement(variable.getName(), (org.eclipse.ocl.expressions.Variable)variable, true);
        this.explicitVariableMap.put(variable.getName(), variable);
    }

    public QVTrDomainEnvironment createEnvironment(DomainCS domainCS) {
        QVTrDomainEnvironment environment = new QVTrDomainEnvironment(this, domainCS);
        RelationDomain domain = environment.getDomain();
        ((Relation)this.ast).getDomain().add((Object)domain);
        this.domEnvMap.put(domainCS, environment);
        return environment;
    }

    public QVTrDomainEnvironment createEnvironment(PrimitiveTypeDomainCS domainCS) {
        QVTrDomainEnvironment environment = new QVTrDomainEnvironment(this, domainCS);
        RelationDomain domain = environment.getDomain();
        ((Relation)this.ast).getDomain().add((Object)domain);
        this.domEnvMap.put(domainCS, environment);
        return environment;
    }

    public void createReferencedVariables(AbstractQVTrAnalyzer parser) {
        for (String name : this.implicitVariableMap.keySet()) {
            EClass explicitElementClass;
            CollectionType explicitCollectionType;
            List<ImplicitVariable> implicitVariables = this.implicitVariableMap.get(name);
            Variable variable = this.explicitVariableMap.get(name);
            EClassifier explicitType = variable != null ? (EClassifier)variable.getType() : null;
            CollectionType collectionType = explicitCollectionType = explicitType instanceof CollectionType ? (CollectionType)explicitType : null;
            if (explicitCollectionType != null) {
                explicitCollectionType.getKind();
            }
            EClassifier explicitElementType = explicitCollectionType != null ? (EClassifier)explicitCollectionType.getElementType() : explicitType;
            EClass eClass = explicitElementClass = explicitElementType instanceof EClass ? (EClass)explicitElementType : null;
            if (variable == null) {
                variable = this.createVariableDeclaration(name, null, implicitVariables.get((int)0).cstNode);
            }
            for (ImplicitVariable implicitVariable : implicitVariables) {
                EClassifier implicitType;
                EClassifier resolvedElementType;
                EClassifier resolvedType = (EClassifier)variable.getType();
                CollectionType resolvedCollectionType = resolvedType instanceof CollectionType ? (CollectionType)resolvedType : null;
                CollectionKind resolvedCollectionKind = resolvedCollectionType != null ? resolvedCollectionType.getKind() : null;
                EClassifier eClassifier = resolvedElementType = resolvedCollectionType != null ? (EClassifier)resolvedCollectionType.getElementType() : resolvedType;
                if (resolvedElementType instanceof EClass) {
                    EClass cfr_ignored_0 = (EClass)resolvedElementType;
                }
                CollectionType implicitCollectionType = (implicitType = implicitVariable.type) instanceof CollectionType ? (CollectionType)implicitType : null;
                CollectionKind implicitCollectionKind = implicitCollectionType != null ? implicitCollectionType.getKind() : null;
                EClassifier implicitElementType = implicitCollectionType != null ? (EClassifier)implicitCollectionType.getElementType() : implicitType;
                EClass implicitElementClass = implicitElementType instanceof EClass ? (EClass)implicitElementType : null;
                boolean isConflicting = false;
                if (resolvedElementType == null) {
                    this.getUMLReflection().setType((TypedElement)variable, (Object)implicitType);
                } else if (resolvedCollectionKind == null && implicitCollectionKind != null) {
                    isConflicting = this.checkImplicitElementType(explicitElementClass, implicitVariable, implicitElementClass);
                } else if (resolvedCollectionKind != null != (implicitCollectionKind != null)) {
                    isConflicting = true;
                } else if (resolvedElementType != implicitElementType) {
                    if (explicitElementClass != null) {
                        isConflicting = this.checkImplicitElementType(explicitElementClass, implicitVariable, implicitElementClass);
                    } else if (explicitElementType != null) {
                        isConflicting = true;
                    } else {
                        CollectionKind commonCollectionKind = OCLUtils.commonCollectionKind((CollectionKind)resolvedCollectionKind, (CollectionKind)implicitCollectionKind);
                        EClassifier commonElementType = (EClassifier)TypeUtil.commonSuperType(null, (Environment)this, (Object)resolvedElementType, (Object)implicitElementType);
                        if (commonElementType != resolvedElementType || commonCollectionKind != resolvedCollectionKind) {
                            if (commonElementType == implicitElementType && commonCollectionKind == implicitCollectionKind) {
                                variable.setType((Object)implicitType);
                            } else if (commonElementType != null) {
                                if (commonCollectionKind == null) {
                                    variable.setType((Object)commonElementType);
                                } else {
                                    variable.setType((Object)OCLUtils.getOCLCollectionType((EClassifier)commonElementType, (boolean)OCLUtils.isOrdered((CollectionKind)commonCollectionKind), (boolean)OCLUtils.isUnique((CollectionKind)commonCollectionKind)));
                                }
                            } else {
                                isConflicting = true;
                            }
                        }
                    }
                }
                if (!isConflicting) continue;
                String message = "Conflicting type '" + parser.formatType(implicitType) + "' for '" + name + ":" + parser.formatType(resolvedType) + "'";
                this.analyzerError(message, "implicit varDeclarationCS", implicitVariable.cstNode);
            }
        }
    }

    protected boolean checkImplicitElementType(EClass explicitElementClass, ImplicitVariable implicitVariable, EClass implicitElementClass) {
        boolean isConflicting = implicitElementClass == null ? true : (implicitElementClass == explicitElementClass ? false : (!implicitVariable.isInvocation() && implicitVariable.isEnforced() ? !implicitElementClass.isSuperTypeOf(explicitElementClass) : (!implicitVariable.isInvocation() && !implicitVariable.isEnforced() ? true : (implicitVariable.isInvocation() && implicitVariable.isChecked() ? !implicitElementClass.isSuperTypeOf(explicitElementClass) && !explicitElementClass.isSuperTypeOf(implicitElementClass) : (implicitVariable.isInvocation() && implicitVariable.isEnforced() ? !implicitElementClass.isSuperTypeOf(explicitElementClass) : (implicitVariable.isInvocation() && !implicitVariable.isEnforced() ? true : true))))));
        return isConflicting;
    }

    public void createVariableDeclaration(VariableExpCS variableExpCS, EClassifier type, Domain domain, boolean isInvocation) {
        SimpleNameCS simpleNameCS = variableExpCS.getSimpleNameCS();
        String name = simpleNameCS.getValue();
        Variable explicitVariable = this.explicitVariableMap.get(name);
        if (explicitVariable == null) {
            List<ImplicitVariable> list = this.implicitVariableMap.get(name);
            if (list == null) {
                list = new ArrayList<ImplicitVariable>();
                this.implicitVariableMap.put(name, list);
            }
            if (!list.contains(type)) {
                list.add(new ImplicitVariable(type, domain, isInvocation, (CSTNode)simpleNameCS));
            }
        }
    }

    @Override
    public Variable createVariableDeclaration(IdentifierCS identifierCS, EClassifier type) {
        Variable createVariableDeclaration = this.createVariableDeclaration(identifierCS.getValue(), type, (CSTNode)identifierCS);
        return createVariableDeclaration;
    }

    private Variable createVariableDeclaration(String name, EClassifier type, CSTNode cstNode) {
        Variable variable = this.explicitVariableMap.get(name);
        if (variable != null) {
            if (variable.getType() != type) {
                String message = "Conflicting type '" + this.formatType(type) + "' for variable of type '" + this.formatType(variable.getType()) + "'";
                this.analyzerError(message, "explicit varDeclarationCS", cstNode);
            }
        } else {
            variable = EcoreFactory.eINSTANCE.createVariable();
            this.initASTMapping(variable, cstNode);
            variable.setName(name);
            variable.setType((Object)type);
            this.addExplicitVariable(variable);
        }
        return variable;
    }

    public QVTrDomainEnvironment getEnvironment(DomainCS domainCS) {
        return this.domEnvMap.get(domainCS);
    }

    public Relation getRelation() {
        return (Relation)this.ast;
    }

    @Override
    public Relation getRelation(List<String> pathName, String relationName) {
        RelationalTransformation transformation = this.getRelationalTransformation();
        if (pathName != null) {
            transformation = this.getRelationalTransformation(pathName);
        }
        return transformation != null ? transformation.getRelation(relationName) : null;
    }

    public Variable getVariable(String name) {
        return this.explicitVariableMap.get(name);
    }

    public Variable tryLookupVariable(String name) {
        return this.getVariable(name);
    }

    private static class ImplicitVariable {
        public final EClassifier type;
        public final Domain domain;
        public final boolean isInvocation;
        public final CSTNode cstNode;

        public ImplicitVariable(EClassifier type, Domain domain, boolean isInvocation, CSTNode cstNode) {
            this.type = type;
            this.domain = domain;
            this.isInvocation = isInvocation;
            this.cstNode = cstNode;
        }

        public boolean isChecked() {
            return this.domain.isIsCheckable();
        }

        public boolean isEnforced() {
            return this.domain.isIsEnforceable();
        }

        public boolean isInvocation() {
            return this.isInvocation;
        }
    }
}

