/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.execution.ide;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.qvt.declarative.execution.ExecutionContext;
import org.eclipse.qvt.declarative.execution.ExecutionContextFactory;
import org.eclipse.qvt.declarative.execution.ExecutionService;
import org.eclipse.qvt.declarative.execution.LabelledModel;
import org.eclipse.qvt.declarative.execution.LabelledModelFactory;
import org.eclipse.qvt.declarative.execution.ide.Activator;

public class DeclarativeQVTLaunchDelegate
implements ILaunchConfigurationDelegate {
    public static final String EXECUTABLE_PATH_ATTRIBUTE_NAME = "QVTExecutableAttributeName";
    public static final String MODEL_NAME_LIST_ATTRIBUTE_NAME = "QVTModelNamesAttributeName";
    public static final String MODEL_PATH_LIST_ATTRIBUTE_NAME = "QVTModelPathsAttributeName";
    public static final String METAMODEL_NAME_LIST_ATTRIBUTE_NAME = "QVTMetamodelNamesAttributeName";
    public static final String METAMODEL_PATH_LIST_ATTRIBUTE_NAME = "QVTMetamodelPathsAttributeName";
    public static final String DIRECTION_MODEL_PATH_ATTRIBUTE_NAME = "QVTDirectionmodelPathsAttributeName";
    public static final String EXECUTION_MODE_ATTRIBUTE_NAME = "QVTExecutionModeAttributeName";
    public static final String EMPTY_STRING = "";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File sourceFile = this.getSourceFile(configuration);
        ExecutionContext parameters = this.getParameters(configuration);
        try {
            ExecutionService.getInstance().execute(sourceFile, parameters);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.qvt.declarative.execution.ide", e.getMessage()));
        }
    }

    private ExecutionContext getParameters(ILaunchConfiguration configuration) throws CoreException {
        List modelNameList = configuration.getAttribute(MODEL_NAME_LIST_ATTRIBUTE_NAME, Collections.EMPTY_LIST);
        List modelPathList = configuration.getAttribute(MODEL_PATH_LIST_ATTRIBUTE_NAME, Collections.EMPTY_LIST);
        List metamodelNameList = configuration.getAttribute(METAMODEL_NAME_LIST_ATTRIBUTE_NAME, Collections.EMPTY_LIST);
        List metamodelPathList = configuration.getAttribute(METAMODEL_PATH_LIST_ATTRIBUTE_NAME, Collections.EMPTY_LIST);
        String direction = configuration.getAttribute(DIRECTION_MODEL_PATH_ATTRIBUTE_NAME, EMPTY_STRING);
        ArrayList<LabelledModel> sourceModels = new ArrayList<LabelledModel>();
        LabelledModel directionModel = null;
        int i = 0;
        while (i < modelPathList.size()) {
            String modelName = (String)modelNameList.get(i);
            String modelPath = (String)modelPathList.get(i);
            String metamodelName = (String)metamodelNameList.get(i);
            String metamodelPath = (String)metamodelPathList.get(i);
            LabelledModel metamodel = LabelledModelFactory.INSTANCE.createLabelledMetamodel(metamodelName, metamodelPath);
            LabelledModel model = LabelledModelFactory.INSTANCE.createLabelledModel(modelName, modelPath, metamodel);
            if (modelName.equals(direction)) {
                directionModel = model;
            } else {
                sourceModels.add(model);
            }
            ++i;
        }
        String modeValue = configuration.getAttribute(EXECUTION_MODE_ATTRIBUTE_NAME, EMPTY_STRING);
        ExecutionContext context = ExecutionContextFactory.INSTANCE.createExecutionContext(sourceModels, directionModel, ExecutionContext.ExecutionMode.valueOf((String)modeValue));
        return context;
    }

    private File getSourceFile(ILaunchConfiguration configuration) throws CoreException {
        String executablePath = configuration.getAttribute(EXECUTABLE_PATH_ATTRIBUTE_NAME, EMPTY_STRING);
        File result = new File(executablePath);
        return result;
    }
}

