/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.utils.DebugStringBuilder;
import org.eclipse.qvt.declarative.editor.ui.utils.IDebugString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugString {
    public static DebugString INSTANCE = new DebugString(true);
    public Map<Class<?>, MethodCall> map = new HashMap();

    public static void debugPrintln(String string) {
        System.out.println(string);
    }

    public static String toDebug(Object object) {
        DebugStringBuilder s = new DebugStringBuilder(INSTANCE);
        s.debug(object);
        return s.toString();
    }

    public static void initialize(DebugString debugUtils) {
        DebugString instance = new DebugString(false);
        debugUtils.registerInstanceMethod(instance, "debugBoolean", Boolean.class);
        debugUtils.registerInstanceMethod(instance, "debugEObject", EObject.class);
        debugUtils.registerInstanceMethod(instance, "debugEmptyList", List.class, Collections.EMPTY_LIST.getClass());
        debugUtils.registerInstanceMethod(instance, "debugNumber", Number.class);
        debugUtils.registerInstanceMethod(instance, "debugResource", Resource.class);
        debugUtils.registerInstanceMethod(instance, "debugResourceSet", ResourceSet.class);
        debugUtils.registerInstanceMethod(instance, "debugString", String.class);
        debugUtils.registerInstanceMethod(instance, "debugURI", URI.class);
    }

    public DebugString(boolean doInit) {
        if (doInit) {
            DebugString.initialize(this);
        }
    }

    public void debug(DebugStringBuilder s, Object object) {
        if (object == null) {
            s.append("<null-Object>");
            return;
        }
        if (object instanceof IDebugString) {
            ((IDebugString)object).toDebugString(s);
            return;
        }
        MethodCall methodCall = this.map.get(object.getClass());
        if (methodCall == null && (methodCall = this.getMethod(object.getClass())) != null) {
            this.map.put(object.getClass(), methodCall);
        }
        if (methodCall != null) {
            methodCall.invoke(s, object);
            return;
        }
        this.getMethod(object.getClass());
        s.append("<unknown-");
        s.append(object.getClass().getSimpleName());
        s.append(" ");
        s.append(object.toString());
        s.append(">");
    }

    public void debugBoolean(DebugStringBuilder s, Boolean object) {
        s.append(object.toString());
    }

    public void debugEObject(DebugStringBuilder s, EObject object) {
        if (object == null) {
            s.append("<null-EObject>");
            return;
        }
        if (object.eIsProxy()) {
            this.debugURI(s, EcoreUtil.getURI((EObject)object));
            return;
        }
        if (object.eContainer() != null) {
            this.debugEObject(s, object.eContainer());
            s.append("/");
        }
        if (object instanceof ENamedElement) {
            String name = ((ENamedElement)object).getName();
            if (name != null) {
                s.append(name);
            } else {
                s.append("<null-named-");
                s.append(object.getClass().getSimpleName());
                s.append(">");
            }
        } else {
            s.append("<unnamed-");
            s.append(object.getClass().getSimpleName());
            s.append(">");
        }
    }

    public void debugEmptyList(DebugStringBuilder s, List<?> object) {
        s.append("<empty-list>");
    }

    public void debugNumber(DebugStringBuilder s, Number object) {
        s.append(object.toString());
    }

    public void debugResource(DebugStringBuilder s, Resource object) {
        s.append("Resource(");
        this.debugURI(s, object.getURI());
        s.append(")");
    }

    public void debugResourceSet(DebugStringBuilder s, ResourceSet object) {
        s.append("ResourceSet");
    }

    public void debugString(DebugStringBuilder s, String object) {
        if (object == null) {
            s.append("<null-String>");
        } else {
            s.append("'");
            s.append(object);
            s.append("'");
        }
    }

    public void debugURI(DebugStringBuilder s, URI object) {
        this.debugString(s, object.toString());
    }

    public MethodCall getMethod(Class<?> cls) {
        MethodCall methodCall;
        Class<?> iCls;
        Class<?> sCls = cls;
        while (sCls != null) {
            MethodCall methodCall2 = this.map.get(sCls);
            if (methodCall2 != null) {
                return methodCall2;
            }
            sCls = sCls.getSuperclass();
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            methodCall = this.map.get(iCls);
            if (methodCall != null) {
                return methodCall;
            }
            ++n2;
        }
        classArray = cls.getInterfaces();
        n = classArray.length;
        n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            methodCall = this.getMethod(iCls);
            if (methodCall != null) {
                return methodCall;
            }
            ++n2;
        }
        sCls = cls.getSuperclass();
        if (sCls != null) {
            return this.getMethod(sCls);
        }
        return null;
    }

    public void registerInstanceMethod(Object instance, String methodName, Class<?> objectClass) {
        this.registerInstanceMethod(instance, methodName, objectClass, objectClass);
    }

    public void registerInstanceMethod(Object instance, String methodName, Class<?> argClass, Class<?> objectClass) {
        Class<?> staticClass = instance.getClass();
        try {
            Method method = staticClass.getDeclaredMethod(methodName, DebugStringBuilder.class, argClass);
            this.map.put(objectClass, new MethodCall(instance, method));
        }
        catch (SecurityException e) {
            QVTEditorPlugin.logError("Failed to register '" + staticClass.getName() + "." + methodName + "'", e);
        }
        catch (NoSuchMethodException e) {
            QVTEditorPlugin.logError("Failed to register '" + staticClass.getName() + "." + methodName + "'", e);
        }
    }

    public void registerStaticMethod(Class<?> staticClass, String methodName, Class<?> objectClass) {
        this.registerStaticMethod(staticClass, methodName, objectClass, objectClass);
    }

    public void registerStaticMethod(Class<?> staticClass, String methodName, Class<?> argClass, Class<?> objectClass) {
        try {
            Method method = staticClass.getDeclaredMethod(methodName, DebugStringBuilder.class, argClass);
            this.map.put(objectClass, new MethodCall(null, method));
        }
        catch (SecurityException e) {
            QVTEditorPlugin.logError("Failed to register '" + staticClass.getName() + "." + methodName + "'", e);
        }
        catch (NoSuchMethodException e) {
            QVTEditorPlugin.logError("Failed to register '" + staticClass.getName() + "." + methodName + "'", e);
        }
    }

    protected static class MethodCall {
        protected final Object instance;
        protected final Method method;

        public MethodCall(Object instance, Method method) {
            this.instance = instance;
            this.method = method;
        }

        public void invoke(DebugStringBuilder s, Object object) {
            try {
                this.method.invoke(this.instance, s, object);
            }
            catch (IllegalArgumentException e) {
                QVTEditorPlugin.logError("Failed to invoke '" + this.method.getName() + "'", e);
            }
            catch (IllegalAccessException e) {
                QVTEditorPlugin.logError("Failed to invoke '" + this.method.getName() + "'", e);
            }
            catch (InvocationTargetException e) {
                QVTEditorPlugin.logError("Failed to invoke '" + this.method.getName() + "'", e);
            }
        }
    }
}

