/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.imp.editor.AnnotationHoverBase;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.imp.services.base.HoverHelperBase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;

public abstract class CommonHoverHelper
extends HoverHelperBase
implements IHoverHelper {
    IReferenceResolver fResolver = null;

    public String getHoverHelpAt(IParseController parseController, ISourceViewer srcViewer, int offset) {
        try {
            String msg;
            List annotations = AnnotationHoverBase.getSourceAnnotationsForLine((ISourceViewer)srcViewer, (int)srcViewer.getDocument().getLineOfOffset(offset));
            if (annotations != null && annotations.size() > 0 && (msg = AnnotationHoverBase.formatAnnotationList((List)annotations)) != null) {
                return msg;
            }
        }
        catch (BadLocationException badLocationException) {
            return "??? (BadLocationException for annotation)";
        }
        Object ast = parseController.getCurrentAst();
        if (ast == null) {
            return null;
        }
        Object sourceNode = null;
        Object targetNode = null;
        Object helpNode = null;
        String msg = null;
        ISourcePositionLocator nodeLocator = parseController.getNodeLocator();
        sourceNode = nodeLocator.findNode(ast, offset);
        if (sourceNode == null) {
            return null;
        }
        if (this.fResolver == null && this.fLanguage != null) {
            try {
                this.fResolver = ServiceFactory.getInstance().getReferenceResolver(this.fLanguage);
            }
            catch (Exception exception) {
                this.getPlugin().writeErrorMsg("Exception getting Reference Resolver service from service factory");
                this.fResolver = null;
            }
        }
        if (this.fResolver != null) {
            targetNode = this.fResolver.getLinkTarget(sourceNode, parseController);
        }
        helpNode = targetNode != null ? targetNode : sourceNode;
        IDocumentationProvider docProvider = null;
        if (this.fLanguage != null) {
            try {
                docProvider = ServiceFactory.getInstance().getDocumentationProvider(this.fLanguage);
            }
            catch (Exception exception) {
                this.getPlugin().writeErrorMsg("Exception getting Documentation Provider Service from service factory");
                this.fResolver = null;
            }
        }
        if (docProvider != null && (msg = docProvider.getDocumentation(helpNode, parseController)) != null) {
            return msg;
        }
        if (helpNode instanceof CSTNode) {
            CSTNode def = (CSTNode)helpNode;
            msg = CommonHoverHelper.getSubstring(parseController, def.getStartOffset(), def.getEndOffset());
            int maxMsgLen = 80;
            if (msg == null || msg.length() == 0) {
                return "No help available";
            }
            if (msg.length() <= maxMsgLen) {
                return msg;
            }
            return msg.subSequence(0, maxMsgLen) + "...";
        }
        return "No help available";
    }

    protected abstract ICommonPlugin getPlugin();

    public static String getSubstring(IParseController parseController, int start, int end) {
        return new String(((CommonParseController)parseController).getLexer().getInputChars(), start, end - start + 1);
    }

    public static String getSubstring(IParseController parseController, IToken token) {
        return CommonHoverHelper.getSubstring(parseController, token.getStartOffset(), token.getEndOffset());
    }
}

