/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.builder.ProblemLimit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarkerProblemHandler<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AbstractProblemHandler
implements IMessageHandler {
    public static final String BUILDER_ID = "builderId";
    public static Map<ProblemHandler.Severity, Integer> severityMap = new HashMap<ProblemHandler.Severity, Integer>();
    protected final ICreationFactory creationFactory;
    protected final IResource resource;
    protected String page = null;
    protected Map<Integer, List<Map<String, Object>>> entries = null;
    private ProblemLimit problemLimit = null;

    static {
        severityMap.put(ProblemHandler.Severity.ERROR, 2);
        severityMap.put(ProblemHandler.Severity.FATAL, 2);
        severityMap.put(ProblemHandler.Severity.INFO, 0);
        severityMap.put(ProblemHandler.Severity.WARNING, 1);
    }

    public MarkerProblemHandler(ICreationFactory creationFactory, IResource resource) {
        super(null);
        this.creationFactory = creationFactory;
        this.resource = resource;
    }

    public void addMarker(int severity, String message, int lineNumber, int charStart, int charEnd) {
        List<Map<String, Object>> lineEntries;
        String adjustedMessage = message;
        if (this.problemLimit != null && (adjustedMessage = this.problemLimit.check(severity, message)) == null) {
            return;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("message", adjustedMessage);
        attributes.put("severity", severity);
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        Integer lineKey = lineNumber;
        attributes.put("lineNumber", lineKey);
        if (charStart <= charEnd) {
            attributes.put("charStart", charStart);
            attributes.put("charEnd", charEnd);
        }
        attributes.put(BUILDER_ID, this.creationFactory.getBuilderId());
        if (this.entries == null) {
            this.entries = new HashMap<Integer, List<Map<String, Object>>>();
        }
        if ((lineEntries = this.entries.get(lineKey)) == null) {
            lineEntries = new ArrayList<Map<String, Object>>();
            this.entries.put(lineKey, lineEntries);
        }
        lineEntries.add(attributes);
        if (adjustedMessage != message) {
            throw new ProblemLimit.LimitExceededException(adjustedMessage);
        }
    }

    public void clearMessages() {
    }

    public void endMessageGroup() {
    }

    public void flush(Monitor monitor) {
        if (this.resource.exists()) {
            IWorkspaceRunnable action = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    String markerId = MarkerProblemHandler.this.creationFactory.getProblemMarkerId();
                    if (MarkerProblemHandler.this.entries != null) {
                        IMarker[] oldMarkers = MarkerProblemHandler.this.resource.findMarkers(markerId, false, 0);
                        IMarker[] iMarkerArray = oldMarkers;
                        int n = oldMarkers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker oldMarker = iMarkerArray[n2];
                            Map oldAttributes = oldMarker.getAttributes();
                            List<Map<String, Object>> lineEntries = MarkerProblemHandler.this.entries.get(oldAttributes.get("lineNumber"));
                            if (lineEntries != null) {
                                for (Map<String, Object> newAttributes : lineEntries) {
                                    if (!MarkerProblemHandler.this.isSameMarker(oldAttributes, newAttributes)) continue;
                                    lineEntries.remove(newAttributes);
                                    oldMarker = null;
                                    break;
                                }
                            }
                            if (oldMarker != null) {
                                oldMarker.delete();
                            }
                            ++n2;
                        }
                        for (List<Map<String, Object>> lineEntries : MarkerProblemHandler.this.entries.values()) {
                            for (Map map : lineEntries) {
                                IMarker marker = MarkerProblemHandler.this.resource.createMarker(markerId);
                                marker.setAttributes(map);
                            }
                        }
                    } else {
                        MarkerProblemHandler.this.resource.deleteMarkers(markerId, false, 0);
                    }
                }
            };
            try {
                IProgressMonitor progressMonitor = monitor != null ? BasicMonitor.toIProgressMonitor((Monitor)monitor) : new NullProgressMonitor();
                this.resource.getWorkspace().run(action, (ISchedulingRule)this.resource, 1, progressMonitor);
            }
            catch (CoreException e) {
                QVTEditorPlugin.logError("Failed to update resource markers", e);
            }
        }
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        Integer severity;
        int leftToken;
        int line = -1;
        if (startOffset >= 0 && (leftToken = Math.abs(this.getParser().getTokenIndexAtCharacter(startOffset))) >= 0) {
            line = this.getParser().getLine(leftToken);
        }
        this.addMarker((severity = severityMap.get(problemSeverity)) != null ? severity : 2, processingPhase + ": " + problemMessage, line, startOffset, endOffset + 1);
    }

    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        this.addMarker(2, msg, startLine, startOffset, endOffset + 1);
    }

    public boolean isSameMarker(Map<?, ?> oldAttributes, Map<String, Object> newAttributes) {
        Set<?> oldKeys = oldAttributes.keySet();
        Set<String> newKeys = newAttributes.keySet();
        if (oldKeys.size() != newKeys.size()) {
            return false;
        }
        for (String key : newKeys) {
            Object newValue;
            if (!oldAttributes.containsKey(key)) {
                return false;
            }
            Object oldValue = oldAttributes.get(key);
            if (oldValue == (newValue = newAttributes.get(key))) continue;
            if (oldValue == null) {
                return false;
            }
            if (newValue == null) {
                return false;
            }
            if (oldValue.equals(newValue)) continue;
            return false;
        }
        return true;
    }

    public void setProblemLimit(ProblemLimit problemLimit) {
        this.problemLimit = problemLimit;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void startMessageGroup(String groupName) {
    }
}

