/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.qvt.declarative.ecore.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreUtils {
    public static <E extends EObject> E copy(E newObject) {
        return (E)EcoreUtil.copy(newObject);
    }

    public static String diagnoseUnresolvedProxies(URI contextURI, Map<EObject, Collection<EStructuralFeature.Setting>> map) {
        if (map.isEmpty()) {
            return null;
        }
        HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>> unresolvedURIs = new HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>>(map.size());
        for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry : map.entrySet()) {
            String uriString;
            EObject key = entry.getKey();
            URI uri = EcoreUtil.getURI((EObject)key);
            if (uri == null || unresolvedURIs.containsKey(uriString = uri.toString())) continue;
            unresolvedURIs.put(uriString, entry);
        }
        StringBuffer s = new StringBuffer();
        s.append("Unresolved URIs in '" + String.valueOf(contextURI) + "' :");
        for (Map.Entry unresolvedURI : unresolvedURIs.entrySet()) {
            s.append("\n    '" + (String)unresolvedURI.getKey() + "'");
        }
        return s.toString();
    }

    @Deprecated
    public static String formatFullName(Object object) {
        return EcoreUtils.formatQualifiedName(object, "::");
    }

    public static String formatMultiplicity(ETypedElement typedElement) {
        int upper;
        if (typedElement == null) {
            return "";
        }
        int lower = typedElement.getLowerBound();
        if (lower == (upper = typedElement.getUpperBound())) {
            return Integer.toString(lower);
        }
        if (lower == 0) {
            if (upper < 0) {
                return "*";
            }
            if (upper == 1) {
                return "?";
            }
        } else if (lower == 1 && upper < 0) {
            return "+";
        }
        return String.valueOf(Integer.toString(lower)) + ".." + (upper >= 0 ? Integer.toString(upper) : "*");
    }

    public static String formatName(Object object) {
        if (object == null) {
            return EcoreUtils.formatString(null);
        }
        if (object instanceof ENamedElement) {
            return EcoreUtils.formatString(((ENamedElement)object).getName());
        }
        if (object instanceof EObject) {
            return EcoreUtils.formatString(((EObject)object).eClass().getName());
        }
        return object.getClass().getName();
    }

    public static String formatOrdered(ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isOrdered() && typedElement.isMany() : false;
        return isOrdered ? "{ordered}" : "";
    }

    public static String formatQualifiedName(Object object) {
        return EcoreUtils.formatQualifiedName(object, "::");
    }

    public static String formatQualifiedName(Object object, String separator) {
        EObject container;
        if (object instanceof EObject && (container = ((EObject)object).eContainer()) != null) {
            return String.valueOf(EcoreUtils.formatQualifiedName(container)) + separator + EcoreUtils.formatName(object);
        }
        return EcoreUtils.formatName(object);
    }

    public static String formatString(String name) {
        return name != null ? name : "<null>";
    }

    public static String formatUnique(ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isUnique() && typedElement.isMany() : false;
        return isOrdered ? "{unique}" : "";
    }

    public static <T extends Adapter> T getAdapter(Notifier notifier, Class<T> adapterClass) {
        if (notifier == null) {
            return null;
        }
        return EcoreUtils.getAdapter((List<Adapter>)notifier.eAdapters(), adapterClass);
    }

    public static <T extends Adapter> T getAdapter(List<Adapter> eAdapters, Class<T> adapterClass) {
        return (T)EcoreUtil.getAdapter(eAdapters, adapterClass);
    }

    public static <T> int getFeatureID(Notification notification, T expectedNotifier, Class<T> featureClass) {
        if (expectedNotifier == null) {
            return -1;
        }
        Object notifier = notification.getNotifier();
        if (notifier != expectedNotifier) {
            return -1;
        }
        T castNotifier = ClassUtils.asClassOrNull(notifier, featureClass);
        if (castNotifier == null) {
            throw new IllegalArgumentException("EcoreUtils.getFeatureID: " + featureClass.getName() + " for a " + notifier.getClass().getName());
        }
        return notification.getFeatureID(featureClass);
    }

    public static <T extends ENamedElement> T getNamedElement(Collection<T> elements, String name) {
        if (elements == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!name.equals(element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static <T extends ENamedElement, R extends T> R getNamedElement(Collection<T> elements, String name, Class<R> returnClass) {
        if (elements == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (returnClass == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!returnClass.isAssignableFrom(element.getClass()) || !name.equals(element.getName())) continue;
            return (R)element;
        }
        return null;
    }
}

