/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.ProblemOption;

public abstract class AbstractParser
extends PrsStream {
    private final BasicEnvironment environment;

    public AbstractParser(BasicEnvironment environment) {
        this.environment = environment;
        environment.setParser(this);
    }

    public AbstractParser(AbstractLexer lexer) {
        super((LexStream)lexer);
        this.environment = lexer.getEnvironment();
        this.environment.setParser(this);
    }

    public String computeInputString(int left, int right) {
        StringBuffer result = new StringBuffer(right - left + 1);
        char[] chars = this.getInputChars();
        if (chars.length > 0) {
            int i = left;
            while (i <= right) {
                if (chars[i] == '\t') {
                    result.append(' ');
                } else if (chars[i] == '\n' || chars[i] == '\r' || chars[i] == '\f') {
                    if (i > 0 && !Character.isWhitespace(chars[i - 1])) {
                        result.append(' ');
                    }
                } else {
                    result.append(chars[i]);
                }
                ++i;
            }
        }
        return result.toString();
    }

    public BasicEnvironment getEnvironment() {
        return this.environment;
    }

    public AbstractLexer getLexer() {
        return (AbstractLexer)super.getLexStream();
    }

    public CSTNode parseTokensToCST() {
        return this.parseTokensToCST(null, 0);
    }

    public abstract CSTNode parseTokensToCST(Monitor var1, int var2);

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        BasicEnvironment environment = this.getEnvironment();
        if (environment == null) {
            super.reportError(errorCode, locationInfo, leftToken, rightToken, tokenText);
        } else {
            if (errorCode == 6 || errorCode == 8) {
                tokenText = "";
            }
            environment.parserError(errorCode, leftToken, rightToken, tokenText);
        }
    }

    public void resetLexStream(LexStream lexStream) {
        this.setLexStream((AbstractLexer)lexStream);
    }

    public void setLexStream(AbstractLexer lexStream) {
        super.resetLexStream((LexStream)lexStream);
    }

    protected void setOffsets(CSTNode cstNode, IToken startEnd) {
        cstNode.setStartToken(startEnd);
        cstNode.setEndToken(startEnd);
        cstNode.setStartOffset(startEnd.getStartOffset());
        cstNode.setEndOffset(startEnd.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, CSTNode startEnd) {
        cstNode.setStartToken(startEnd.getStartToken());
        cstNode.setEndToken(startEnd.getEndToken());
        cstNode.setStartOffset(startEnd.getStartOffset());
        cstNode.setEndOffset(startEnd.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, CSTNode start, CSTNode end) {
        cstNode.setStartToken(start.getStartToken());
        cstNode.setEndToken(end.getEndToken());
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, CSTNode start, IToken end) {
        cstNode.setStartToken(start.getStartToken());
        cstNode.setEndToken(end);
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, IToken start, CSTNode end) {
        cstNode.setStartToken(start);
        cstNode.setEndToken(end.getEndToken());
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected void setOffsets(CSTNode cstNode, IToken start, IToken end) {
        cstNode.setStartToken(start);
        cstNode.setEndToken(end);
        cstNode.setStartOffset(start.getStartOffset());
        cstNode.setEndOffset(end.getEndOffset());
    }

    protected String unquote(String quoted) {
        String result = quoted;
        if (result != null && result.length() > 1) {
            int max = result.length() - 1;
            if (result.charAt(0) == '\"' && quoted.charAt(max) == '\"') {
                result = result.substring(1, max);
            }
            if (!(result = result.replaceAll("\\\\\"", "\"")).equals(quoted)) {
                ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
                BasicEnvironment benv = this.getEnvironment();
                if (benv != null) {
                    sev = benv.getValue(ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE);
                }
                if (sev != null && sev != ProblemHandler.Severity.OK) {
                    benv.problem(sev, ProblemHandler.Phase.PARSER, OCLMessages.bind(OCLMessages.NonStd_DQuote_Escape_, quoted), "unquote", null);
                }
            }
        }
        return result;
    }
}

