/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.deseralization;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.ObjectToRdf;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.Utils;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JsonLdToRdf {
    private static final Logger LOGGER = Logger.getLogger(JsonLdToRdf.class.getName());
    private final NodeMap nodeMap;
    private final RdfDataset dataset;
    private boolean produceGeneralizedRdf;
    private JsonLdOptions.RdfDirection rdfDirection;

    private JsonLdToRdf(NodeMap nodeMap, RdfDataset dataset) {
        this.nodeMap = nodeMap;
        this.dataset = dataset;
        this.produceGeneralizedRdf = false;
        this.rdfDirection = null;
    }

    public static final JsonLdToRdf with(NodeMap nodeMap, RdfDataset dataset) {
        return new JsonLdToRdf(nodeMap, dataset);
    }

    public JsonLdToRdf produceGeneralizedRdf(boolean enable) {
        this.produceGeneralizedRdf = enable;
        return this;
    }

    public JsonLdToRdf rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public RdfDataset build() throws JsonLdError {
        for (String graphName : Utils.index(this.nodeMap.graphs(), true)) {
            RdfResource rdfGraphName;
            if ("@default".equals(graphName)) {
                rdfGraphName = null;
            } else if (BlankNode.isWellFormed(graphName)) {
                rdfGraphName = Rdf.createBlankNode(graphName);
            } else {
                if (!UriUtils.isAbsoluteUri(graphName)) continue;
                rdfGraphName = Rdf.createIRI(graphName);
            }
            for (String subject : Utils.index(this.nodeMap.subjects(graphName), true)) {
                RdfResource rdfSubject;
                if (BlankNode.isWellFormed(subject)) {
                    rdfSubject = Rdf.createBlankNode(subject);
                } else if (UriUtils.isAbsoluteUri(subject)) {
                    rdfSubject = Rdf.createIRI(subject);
                } else {
                    LOGGER.log(Level.WARNING, "Non well-formed subject [{0}] has been skipped.", subject);
                    continue;
                }
                for (String property : Utils.index(this.nodeMap.properties(graphName, subject), true)) {
                    if ("@type".equals(property)) {
                        for (JsonValue type : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                            RdfResource rdfObject2;
                            if (JsonUtils.isNotString(type)) continue;
                            String typeString = ((JsonString)type).getString();
                            if (BlankNode.isWellFormed(typeString)) {
                                rdfObject2 = Rdf.createBlankNode(typeString);
                            } else {
                                if (!UriUtils.isAbsoluteUri(typeString)) continue;
                                rdfObject2 = Rdf.createIRI(typeString);
                            }
                            this.dataset.add(Rdf.createNQuad(rdfSubject, Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), rdfObject2, rdfGraphName));
                        }
                        continue;
                    }
                    if (Keywords.contains(property) || (!BlankNode.isWellFormed(property) || this.produceGeneralizedRdf) && !UriUtils.isAbsoluteUri(property)) continue;
                    for (JsonValue item : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                        ArrayList<RdfTriple> listTriples = new ArrayList<RdfTriple>();
                        ObjectToRdf.with(item.asJsonObject(), listTriples, this.nodeMap).rdfDirection(this.rdfDirection).build().ifPresent(rdfObject -> this.dataset.add(Rdf.createNQuad(rdfSubject, Rdf.createResource(property), rdfObject, rdfGraphName)));
                        listTriples.stream().map(triple -> Rdf.createNQuad(triple, rdfGraphName)).forEach(this.dataset::add);
                    }
                }
            }
        }
        return this.dataset;
    }
}

