/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.util.Objects;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdflink.LibRDFLink;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecApp;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecDatasetBuilder;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.GraphReadOnly;
import org.apache.jena.system.Txn;
import org.apache.jena.update.UpdateRequest;

public class RDFLinkDataset
implements RDFLink {
    private ThreadLocal<Boolean> transactionActive = ThreadLocal.withInitial(() -> false);
    private DatasetGraph dataset;
    private final Isolation isolation;

    private RDFLinkDataset(DatasetGraph dataset) {
        this(dataset, Isolation.NONE);
    }

    RDFLinkDataset(DatasetGraph dataset, Isolation isolation) {
        this.dataset = dataset;
        this.isolation = isolation;
    }

    @Override
    public QueryExec query(Query query) {
        this.checkOpen();
        return QueryExecApp.create((QueryExecMod)QueryExec.dataset((DatasetGraph)this.dataset).query(query), (DatasetGraph)this.dataset, (Query)query, null);
    }

    @Override
    public QueryExecBuilder newQuery() {
        return QueryExec.dataset((DatasetGraph)this.dataset);
    }

    @Override
    public UpdateExecBuilder newUpdate() {
        return UpdateExec.dataset((DatasetGraph)this.dataset);
    }

    @Override
    public void update(UpdateRequest update) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> UpdateExecDatasetBuilder.create().update(update).execute(this.dataset));
    }

    @Override
    public void load(Node graphName, String file) {
        this.checkOpen();
        this.doPutPost(graphName, file, false);
    }

    @Override
    public void load(String file) {
        this.checkOpen();
        this.doPutPost(null, file, false);
    }

    @Override
    public void load(Node graphName, Graph graphSrc) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            Graph graphDst = this.graphFor(graphName);
            G.copyGraphSrcToDst((Graph)graphSrc, (Graph)graphDst);
        });
    }

    @Override
    public void load(Graph graph) {
        this.load(null, graph);
    }

    @Override
    public Graph get(Node graphName) {
        this.checkOpen();
        return (Graph)Txn.calculateRead((Transactional)this.dataset, () -> {
            Graph graph = this.graphFor(graphName);
            return this.isolate(graph);
        });
    }

    @Override
    public Graph get() {
        this.checkOpen();
        return this.get(null);
    }

    @Override
    public void put(String file) {
        this.checkOpen();
        this.doPutPost(null, file, true);
    }

    @Override
    public void put(Node graphName, String file) {
        this.checkOpen();
        this.doPutPost(graphName, file, true);
    }

    @Override
    public void put(Graph graph) {
        this.put(null, graph);
    }

    @Override
    public void put(Node graphName, Graph graph) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            Graph graphDst = this.graphFor(graphName);
            G.clear((Graph)graphDst);
            G.copyGraphSrcToDst((Graph)graph, (Graph)graphDst);
        });
    }

    @Override
    public void delete(Node graphName) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            if (LibRDFLink.isDefault(graphName)) {
                G.clear((Graph)this.dataset.getDefaultGraph());
            } else {
                G.clear((Graph)this.dataset.getGraph(graphName));
            }
        });
    }

    @Override
    public void delete() {
        this.checkOpen();
        this.delete(null);
    }

    private void doPutPost(Node graphName, String file, boolean replace) {
        Objects.requireNonNull(file);
        Lang lang = RDFLanguages.filenameToLang((String)file);
        Txn.executeWrite((Transactional)this.dataset, () -> {
            if (RDFLanguages.isTriples((Lang)lang)) {
                Graph graph;
                Graph graph2 = graph = LibRDFLink.isDefault(graphName) ? this.dataset.getDefaultGraph() : this.dataset.getGraph(graphName);
                if (replace) {
                    G.clear((Graph)graph);
                }
                RDFDataMgr.read((Graph)graph, (String)file);
            } else if (RDFLanguages.isQuads((Lang)lang)) {
                if (replace) {
                    this.dataset.clear();
                }
                RDFDataMgr.read((DatasetGraph)this.dataset, (String)file);
            } else {
                throw new ARQException("Not an RDF format: " + file + " (lang=" + lang + ")");
            }
        });
    }

    private Graph isolate(Graph graph) {
        switch (this.isolation) {
            case COPY: {
                Graph graph2 = GraphFactory.createDefaultGraph();
                G.copyGraphSrcToDst((Graph)graph, (Graph)graph2);
                return graph2;
            }
            case READONLY: {
                GraphReadOnly graph2 = new GraphReadOnly(graph);
                return graph2;
            }
            case NONE: {
                return graph;
            }
        }
        throw new InternalErrorException();
    }

    private DatasetGraph isolate(DatasetGraph dataset) {
        switch (this.isolation) {
            case COPY: {
                DatasetGraph dsg2 = DatasetGraphFactory.create();
                dataset.find().forEachRemaining(q -> dsg2.add(q));
                return dsg2;
            }
            case READONLY: {
                DatasetGraphReadOnly dsg = new DatasetGraphReadOnly(dataset);
                return dsg;
            }
            case NONE: {
                return dataset;
            }
        }
        throw new InternalErrorException();
    }

    private Graph graphFor(Node graphName) {
        if (LibRDFLink.isDefault(graphName)) {
            return this.dataset.getDefaultGraph();
        }
        return this.dataset.getGraph(graphName);
    }

    @Override
    public DatasetGraph getDataset() {
        this.checkOpen();
        return (DatasetGraph)Txn.calculateRead((Transactional)this.dataset, () -> this.isolate(this.dataset));
    }

    @Override
    public void loadDataset(String file) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> RDFDataMgr.read((DatasetGraph)this.dataset, (String)file));
    }

    @Override
    public void loadDataset(DatasetGraph srcDataset) {
        this.checkOpen();
        srcDataset.executeRead(() -> this.dataset.executeWrite(() -> srcDataset.find().forEachRemaining(q -> this.dataset.add(q))));
    }

    @Override
    public void putDataset(String file) {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> {
            this.dataset.clear();
            RDFDataMgr.read((DatasetGraph)this.dataset, (String)file);
        });
    }

    @Override
    public void putDataset(DatasetGraph dataset) {
        this.checkOpen();
        Txn.executeWrite((Transactional)dataset, () -> {
            this.dataset = this.isolate(dataset);
        });
    }

    @Override
    public void clearDataset() {
        this.checkOpen();
        Txn.executeWrite((Transactional)this.dataset, () -> ((DatasetGraph)this.dataset).clear());
    }

    @Override
    public void close() {
        this.dataset = null;
    }

    @Override
    public boolean isClosed() {
        return this.dataset == null;
    }

    private void checkOpen() {
        if (this.dataset == null) {
            throw new ARQException("closed");
        }
    }

    public void begin() {
        this.dataset.begin();
    }

    public void begin(TxnType txnType) {
        this.dataset.begin(txnType);
    }

    public void begin(ReadWrite mode) {
        this.dataset.begin(mode);
    }

    public boolean promote(Transactional.Promote promote) {
        return this.dataset.promote(promote);
    }

    public void commit() {
        this.dataset.commit();
    }

    public void abort() {
        this.dataset.abort();
    }

    public boolean isInTransaction() {
        return this.dataset.isInTransaction();
    }

    public void end() {
        this.dataset.end();
    }

    public ReadWrite transactionMode() {
        return this.dataset.transactionMode();
    }

    public TxnType transactionType() {
        return this.dataset.transactionType();
    }
}

