/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.presentation;

import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.breakpoints.DSPLineBreakpoint;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.presentation.SourceCodeEditor;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class DSPBreakpointDetailPane
implements IDetailPane {
    public static final String ID = "org.eclipse.lsp4e.debug.detailPane.breakpoint";
    public static final String NAME = "LSP4E Breakpoint";
    public static final String DESCRIPTION = "Edit condition and column for LSP4E breakpoints";
    private Composite control = (Composite)NullSafetyHelper.lateNonNull();
    private Button enableConditionButton = (Button)NullSafetyHelper.lateNonNull();
    private SourceCodeEditor conditionEditor = (SourceCodeEditor)((Object)NullSafetyHelper.lateNonNull());
    private Button enableHitConditionButton = (Button)NullSafetyHelper.lateNonNull();
    private Text hitConditionText = (Text)NullSafetyHelper.lateNonNull();
    private Spinner columnSpinner = (Spinner)NullSafetyHelper.lateNonNull();
    private @Nullable DSPLineBreakpoint selectedBP = null;
    private volatile boolean updating;

    private @Nullable Capabilities getDebugAdapterCapabilities() {
        Capabilities capabilities;
        Object targetObj;
        IAdaptable ctx = DebugUITools.getDebugContext();
        if (ctx == null) {
            return null;
        }
        if (ctx instanceof IDebugElement) {
            IDebugElement de = (IDebugElement)ctx;
            v0 = de.getDebugTarget();
        } else {
            v0 = targetObj = Adapters.adapt((Object)ctx, IDebugTarget.class);
        }
        if (targetObj instanceof DSPDebugTarget) {
            DSPDebugTarget dt = (DSPDebugTarget)((Object)targetObj);
            capabilities = dt.getCapabilities();
        } else {
            capabilities = null;
        }
        return capabilities;
    }

    private @Nullable DSPLineBreakpoint getSelectedBreakPoint(IStructuredSelection selection) {
        DSPLineBreakpoint d;
        Object adapted;
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first == null) {
            return null;
        }
        if (first instanceof DSPLineBreakpoint) {
            DSPLineBreakpoint d2 = (DSPLineBreakpoint)((Object)first);
            return d2;
        }
        if (!(first instanceof IBreakpoint) && (adapted = Platform.getAdapterManager().getAdapter(first, IBreakpoint.class)) instanceof IBreakpoint) {
            IBreakpoint b = (IBreakpoint)adapted;
            first = b;
        }
        return first instanceof DSPLineBreakpoint ? (d = (DSPLineBreakpoint)((Object)first)) : null;
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setBackground(UI.getDisplay().getSystemColor(25));
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(this.control);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.control);
        Composite colRow = new Composite(this.control, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).equalWidth(false).applyTo(colRow);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)colRow);
        String colHint = "Inline breakpoint column (1-based).\nSet > 0 to break at a specific character position on this line; set 0 to use the adapter's default stoppable location.";
        Label colLabel = new Label(colRow, 0);
        colLabel.setText("Column");
        colLabel.setToolTipText("Inline breakpoint column (1-based).\nSet > 0 to break at a specific character position on this line; set 0 to use the adapter's default stoppable location.");
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)colLabel);
        this.columnSpinner = new Spinner(colRow, 2048);
        this.columnSpinner.setMinimum(0);
        this.columnSpinner.setMaximum(Integer.MAX_VALUE);
        this.columnSpinner.setToolTipText("Inline breakpoint column (1-based).\nSet > 0 to break at a specific character position on this line; set 0 to use the adapter's default stoppable location.");
        GridDataFactory.swtDefaults().hint(100, -1).applyTo((Control)this.columnSpinner);
        String hitHint = "Trigger this breakpoint only on specific hit counts.\nExamples: 5 (5th hit), >= 10 (10th and later), % 3 == 0 (every 3rd hit).";
        Composite hitRow = new Composite(this.control, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).equalWidth(false).applyTo(hitRow);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hitRow);
        this.enableHitConditionButton = new Button(hitRow, 32);
        this.enableHitConditionButton.setText("Hit condition");
        this.enableHitConditionButton.setToolTipText("Trigger this breakpoint only on specific hit counts.\nExamples: 5 (5th hit), >= 10 (10th and later), % 3 == 0 (every 3rd hit).");
        GridDataFactory.swtDefaults().indent(0, 0).align(1, 0x1000000).applyTo((Control)this.enableHitConditionButton);
        this.hitConditionText = new Text(hitRow, 2048);
        this.hitConditionText.setToolTipText("Trigger this breakpoint only on specific hit counts.\nExamples: 5 (5th hit), >= 10 (10th and later), % 3 == 0 (every 3rd hit).");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.hitConditionText);
        String condHint = "The breakpoint stops only if the expression evaluates to true in the program context.";
        this.enableConditionButton = new Button(this.control, 32);
        this.enableConditionButton.setText("Condition");
        this.enableConditionButton.setToolTipText("The breakpoint stops only if the expression evaluates to true in the program context.");
        this.conditionEditor = SourceCodeEditor.create(this.control, 0);
        this.conditionEditor.setToolTipText("The breakpoint stops only if the expression evaluates to true in the program context.");
        this.conditionEditor.setEditorLayoutData(GridDataFactory.fillDefaults().grab(true, true).hint(-1, 120));
        this.hookListeners();
        return this.control;
    }

    public void display(IStructuredSelection selection) {
        DSPLineBreakpoint selectedBP_ = this.selectedBP = this.getSelectedBreakPoint(selection);
        this.updating = true;
        try {
            if (selectedBP_ != null) {
                String condition;
                IMarker m = selectedBP_.getMarker();
                this.conditionEditor.configureForResource(m != null ? m.getResource() : null);
                String hit = selectedBP_.getHitCondition();
                boolean hitEnabled = hit != null && !hit.isBlank();
                this.enableHitConditionButton.setSelection(hitEnabled);
                if (hitEnabled) {
                    String hitNew = hit != null ? hit : "";
                    String hitOld = this.hitConditionText.getText();
                    if (!Objects.equals(hitOld, hitNew)) {
                        Point sel2 = this.hitConditionText.getSelection();
                        int caret2 = sel2.y;
                        this.hitConditionText.setText(hitNew);
                        this.hitConditionText.setSelection(Math.min(caret2, this.hitConditionText.getCharCount()));
                    }
                }
                boolean condEnabled = (condition = selectedBP_.getCondition()) != null && !condition.isBlank();
                this.enableConditionButton.setSelection(condEnabled);
                if (condEnabled) {
                    String newText = condition != null ? condition : "";
                    String oldText = this.conditionEditor.getText();
                    if (!Objects.equals(oldText, newText)) {
                        Point sel = this.conditionEditor.getSelection();
                        int caret = sel.y;
                        this.conditionEditor.setText(newText);
                        this.conditionEditor.setSelection(Math.min(caret, this.conditionEditor.getTextWidget().getCharCount()));
                    }
                }
                this.columnSpinner.setSelection(Math.max(0, selectedBP_.getColumn()));
                this.setEnabled(true);
                Capabilities caps = this.getDebugAdapterCapabilities();
                boolean condSupported = caps == null || caps.getSupportsConditionalBreakpoints() != false;
                this.enableConditionButton.setEnabled(condSupported);
                this.conditionEditor.setEnabled(condSupported);
                boolean hitSupported = caps == null || caps.getSupportsHitConditionalBreakpoints() != false;
                this.enableHitConditionButton.setEnabled(hitSupported);
                this.hitConditionText.setEnabled(hitSupported);
            } else {
                this.enableConditionButton.setSelection(false);
                this.conditionEditor.setText("");
                this.enableHitConditionButton.setSelection(false);
                this.hitConditionText.setText("");
                this.columnSpinner.setSelection(0);
                this.setEnabled(false);
            }
        }
        finally {
            this.updating = false;
        }
    }

    public void dispose() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        this.selectedBP = null;
    }

    public @Nullable String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    private void hookListeners() {
        this.enableConditionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean enabled = this.enableConditionButton.getSelection();
            if (!enabled && this.selectedBP != null) {
                try {
                    this.selectedBP.setCondition(null);
                }
                catch (CoreException ex) {
                    DSPPlugin.logError(ex);
                }
            }
        }));
        this.conditionEditor.addModifyListener(e -> {
            DSPLineBreakpoint selectedBP = this.selectedBP;
            if (this.updating || selectedBP == null) {
                return;
            }
            if (!this.enableConditionButton.getSelection()) {
                this.enableConditionButton.setSelection(true);
            }
            try {
                selectedBP.setCondition(this.conditionEditor.getText());
            }
            catch (CoreException ex) {
                DSPPlugin.logError(ex);
            }
        });
        this.enableHitConditionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean enabled = this.enableHitConditionButton.getSelection();
            if (!enabled && this.selectedBP != null) {
                try {
                    this.selectedBP.setHitCondition(null);
                }
                catch (CoreException ex) {
                    DSPPlugin.logError(ex);
                }
            }
        }));
        this.hitConditionText.addModifyListener(e -> {
            DSPLineBreakpoint selectedBP = this.selectedBP;
            if (this.updating || selectedBP == null) {
                return;
            }
            if (!this.enableHitConditionButton.getSelection()) {
                this.enableHitConditionButton.setSelection(true);
            }
            try {
                selectedBP.setHitCondition(this.hitConditionText.getText());
            }
            catch (CoreException ex) {
                DSPPlugin.logError(ex);
            }
        });
        this.columnSpinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DSPLineBreakpoint selectedBP = this.selectedBP;
            if (this.updating || selectedBP == null) {
                return;
            }
            try {
                selectedBP.setColumn(this.columnSpinner.getSelection());
            }
            catch (CoreException ex) {
                DSPPlugin.logError(ex);
            }
        }));
    }

    public void init(@Nullable IWorkbenchPartSite partSite) {
    }

    private void setEnabled(boolean enabled) {
        this.columnSpinner.setEnabled(enabled);
    }

    public boolean setFocus() {
        if (this.conditionEditor != null && !this.conditionEditor.isDisposed() && this.conditionEditor.isEnabled()) {
            this.conditionEditor.getTextWidget().setFocus();
            return true;
        }
        return false;
    }
}

