/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.sqlite.SQLiteDatabase;
import org.eclipse.hawk.sqlite.SQLiteEdge;
import org.eclipse.hawk.sqlite.iteration.StatementIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteNode
implements IGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteNode.class);
    private final SQLiteDatabase db;
    private final int id;

    public SQLiteNode(SQLiteDatabase db, int nodeId) {
        this.db = db;
        this.id = nodeId;
    }

    public Integer getId() {
        return this.id;
    }

    public Set<String> getPropertyKeys() {
        try {
            PreparedStatement stmt = this.db.getConnection().getNodePropKeysStatement(this.id);
            stmt.execute();
            return this.db.getConnection().getStrings(stmt);
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return Collections.emptySet();
        }
    }

    public Object getProperty(String name) {
        try {
            SQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            PreparedStatement stmt = conn.getNodePropValueStatement();
            stmt.setInt(1, this.id);
            stmt.setString(2, name);
            stmt.execute();
            return conn.getPropertyValue(stmt);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            try {
                SQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
                value = conn.preprocessPropertyValue(value);
                PreparedStatement stmt = conn.getUpsertNodePropStatement(this.id, name, value);
                int rows = stmt.executeUpdate();
                assert (rows == 1) : "One row should have been inserted or updated";
            }
            catch (IOException | SQLException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public Iterable<IGraphEdge> getEdges() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getEdgesStatement(this.id), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            int endId = rs.getInt(3);
            String type = rs.getString(4);
            return new SQLiteEdge(this.db, edgeId, startId, endId, type);
        });
    }

    public Iterable<IGraphEdge> getEdgesWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getEdgesByTypeStatement(this.id, type), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            int endId = rs.getInt(3);
            return new SQLiteEdge(this.db, edgeId, startId, endId, type);
        });
    }

    public Iterable<IGraphEdge> getOutgoingWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getOutgoingEdgesWithTypeStatement(this.id, type), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            return new SQLiteEdge(this.db, edgeId, this.id, endId, type);
        });
    }

    public Iterable<IGraphEdge> getIncomingWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getIncomingEdgesWithTypeStatement(this.id, type), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            return new SQLiteEdge(this.db, edgeId, startId, this.id, type);
        });
    }

    public Iterable<IGraphEdge> getIncoming() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getIncomingEdgesStatement(this.id), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            String type = rs.getString(3);
            return new SQLiteEdge(this.db, edgeId, startId, this.id, type);
        });
    }

    public Iterable<IGraphEdge> getOutgoing() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getConnection().getOutgoingEdgesStatement(this.id), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            String type = rs.getString(3);
            return new SQLiteEdge(this.db, edgeId, this.id, endId, type);
        });
    }

    public void delete() {
        try {
            SQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            conn.getDeleteNodePropsStatement(this.id).executeUpdate();
            conn.getDeleteEdgePropsForNodeStatement(this.id).executeUpdate();
            conn.getDeleteEdgesForNodeStatement(this.id).executeUpdate();
            conn.getDeleteNodeStatement(this.id).executeUpdate();
            for (String idxName : this.db.getNodeIndexNames()) {
                this.db.getOrCreateNodeIndex(idxName).remove((IGraphNode)this);
            }
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public IGraphDatabase getGraph() {
        return this.db;
    }

    public void removeProperty(String name) {
        try {
            PreparedStatement stmt = this.db.getConnection().getDeleteNodePropStatement(this.id, name);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLiteNode other = (SQLiteNode)obj;
        return this.id == other.id;
    }

    public String toString() {
        return String.format("SQLiteNode [id=%s]", this.id);
    }
}

