/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.graph.TypeNode;

public class MetamodelNode {
    private IGraphNode node;

    public MetamodelNode(IGraphNode n) {
        this.node = n;
    }

    public Iterable<TypeNode> getTypes() {
        final Iterable iterableEdges = this.node.getIncomingWithType("epackage");
        return new Iterable<TypeNode>(){

            @Override
            public Iterator<TypeNode> iterator() {
                final Iterator itEdges = iterableEdges.iterator();
                return new Iterator<TypeNode>(){

                    @Override
                    public boolean hasNext() {
                        return itEdges.hasNext();
                    }

                    @Override
                    public TypeNode next() {
                        return new TypeNode(((IGraphEdge)itEdges.next()).getStartNode());
                    }

                    @Override
                    public void remove() {
                        itEdges.remove();
                    }
                };
            }
        };
    }

    public IGraphNode getNode() {
        return this.node;
    }

    public String getUri() {
        return (String)this.node.getProperty("_hawkid");
    }

    public String getType() {
        return (String)this.node.getProperty("type");
    }

    public String getResource() {
        return (String)this.node.getProperty("resource");
    }

    public List<MetamodelNode> getDependencies() {
        ArrayList<MetamodelNode> nodes = new ArrayList<MetamodelNode>();
        for (IGraphEdge e : this.node.getOutgoingWithType("dependency")) {
            IGraphNode depNode = e.getEndNode();
            nodes.add(new MetamodelNode(depNode));
        }
        return nodes;
    }
}

