/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphWrapper.class);
    protected final IGraphDatabase graph;

    public GraphWrapper(IGraphDatabase graph) {
        this.graph = graph;
    }

    public Set<FileNode> getFileNodes(Iterable<String> repoPatterns, Iterable<String> filePatterns) {
        IGraphNodeIndex fileIndex = this.graph.getFileIndex();
        return this.getFileNodes(fileIndex, repoPatterns, filePatterns);
    }

    public Set<FileNode> getFileNodes(IGraphNodeIndex fileIndex, Iterable<String> repoPatterns, Iterable<String> filePatterns) {
        if (repoPatterns == null || !repoPatterns.iterator().hasNext()) {
            repoPatterns = Arrays.asList("*");
        }
        if (filePatterns == null || !filePatterns.iterator().hasNext()) {
            filePatterns = Arrays.asList("*");
        }
        LinkedHashSet<FileNode> files = new LinkedHashSet<FileNode>();
        for (String repo : repoPatterns) {
            for (String file : filePatterns) {
                String fullPattern;
                if ("*".equals(repo) && "*".equals(file)) {
                    fullPattern = "*";
                } else {
                    try {
                        new URI(file);
                    }
                    catch (URISyntaxException ex) {
                        try {
                            file = URLEncoder.encode(file, StandardCharsets.UTF_8.toString()).replaceAll("%2F", "/").replaceAll("[+]", "%20");
                        }
                        catch (UnsupportedEncodingException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    fullPattern = String.valueOf(repo.trim()) + "||||" + file.trim();
                }
                for (IGraphNode n : fileIndex.query("id", (Object)fullPattern)) {
                    files.add(new FileNode(n));
                }
            }
        }
        return files;
    }

    public IGraphDatabase getGraph() {
        return this.graph;
    }

    public ModelElementNode getModelElementNodeById(Object id) {
        IGraphNode rawNode = this.graph.getNodeById(id);
        if (rawNode == null) {
            throw new NoSuchElementException("No node exists with id " + id);
        }
        return new ModelElementNode(rawNode);
    }

    public ModelElementNode getModelElementNodeById(ModelElementNode ctx, Object id) {
        IGraphNode ctxNode = ctx.getNode();
        IGraphNode rawNode = this.graph.getNodeById(id);
        if (rawNode == null) {
            throw new NoSuchElementException("No node exists with id " + id);
        }
        if (ctxNode instanceof ITimeAwareGraphNode) {
            ITimeAwareGraphNode ctxTANode = (ITimeAwareGraphNode)ctxNode;
            ITimeAwareGraphNode rawTANode = (ITimeAwareGraphNode)rawNode;
            return new ModelElementNode((IGraphNode)rawTANode.travelInTime(ctxTANode.getTime()));
        }
        return new ModelElementNode(rawNode);
    }

    public TypeNode getTypeNodeById(String id) {
        IGraphNode rawNode = this.graph.getNodeById((Object)id);
        if (rawNode == null) {
            throw new NoSuchElementException("No type node exists with id " + id);
        }
        return new TypeNode(rawNode);
    }

    public MetamodelNode getMetamodelNodeByNsURI(String nsURI) {
        Iterator metamodelNode = this.graph.getMetamodelIndex().query("id", (Object)nsURI).iterator();
        if (!metamodelNode.hasNext()) {
            throw new NoSuchElementException("No metamodel node exists with URI " + nsURI);
        }
        return new MetamodelNode((IGraphNode)metamodelNode.next());
    }

    public Iterable<MetamodelNode> getMetamodelNodes() {
        final IGraphIterable metamodelNodes = this.graph.getMetamodelIndex().query("*", (Object)"*");
        return new Iterable<MetamodelNode>(){

            @Override
            public Iterator<MetamodelNode> iterator() {
                final Iterator itMN = metamodelNodes.iterator();
                return new Iterator<MetamodelNode>(){

                    @Override
                    public boolean hasNext() {
                        return itMN.hasNext();
                    }

                    @Override
                    public MetamodelNode next() {
                        return new MetamodelNode((IGraphNode)itMN.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

