/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.categorization.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class DerivedAttributeAdapter
extends AdapterImpl {
    private final InternalEObject source;
    private final EStructuralFeature derivedFeature;
    private final List<EStructuralFeature> localFeatures = new ArrayList<EStructuralFeature>();
    private EStructuralFeature dependantFeature;
    private EStructuralFeature navigationFeature;
    private final Adapter dependantAdapter = new EContentAdapter(){

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 1 && (msg.getFeature().equals(DerivedAttributeAdapter.this.dependantFeature) || DerivedAttributeAdapter.this.dependantFeature == null)) {
                DerivedAttributeAdapter.this.notifyDerivedAttributeChange();
            }
        }
    };

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependantFeature);
        this.addLocalDependency(localFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependantFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addLocalDependency(localFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature) {
        this.source = (InternalEObject)source;
        this.derivedFeature = derivedFeature;
        source.eAdapters().add((Object)this);
    }

    public void addNavigatedDependency(EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        this.dependantFeature = dependantFeature;
        this.navigationFeature = navigationFeature;
    }

    public void addLocalDependency(EStructuralFeature localFeature) {
        this.localFeatures.add(localFeature);
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeature().equals(this.navigationFeature)) {
            switch (notification.getEventType()) {
                case 3: {
                    EObject added = (EObject)notification.getNewValue();
                    added.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 1: {
                    EObject newValue = (EObject)notification.getNewValue();
                    EObject oldValue = (EObject)notification.getOldValue();
                    if (oldValue != null) {
                        oldValue.eAdapters().remove((Object)this.dependantAdapter);
                    }
                    if (newValue == null) break;
                    newValue.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 4: {
                    EObject removed = (EObject)notification.getOldValue();
                    removed.eAdapters().remove((Object)this.dependantAdapter);
                    break;
                }
                default: {
                    return;
                }
            }
            this.notifyDerivedAttributeChange();
        } else if (this.localFeatures.contains(notification.getFeature())) {
            this.notifyDerivedAttributeChange();
        }
    }

    private void notifyDerivedAttributeChange() {
        if (this.source.eNotificationRequired()) {
            this.source.eNotify((Notification)new ENotificationImpl(this.source, 1, this.derivedFeature, null, this.source.eGet(this.derivedFeature, true, true)));
        }
    }
}

