/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;

public class PushOperationSpecification {
    private LinkedHashMap<URIish, Collection<RemoteRefUpdate>> urisRefUpdates = new LinkedHashMap();

    public void addURIRefUpdates(URIish uri, Collection<RemoteRefUpdate> refUpdates) {
        this.urisRefUpdates.put(uri, refUpdates);
    }

    public Set<URIish> getURIs() {
        return Collections.unmodifiableSet(this.urisRefUpdates.keySet());
    }

    public int getURIsNumber() {
        return this.urisRefUpdates.size();
    }

    public Collection<RemoteRefUpdate> getRefUpdates(URIish uri) {
        return Collections.unmodifiableCollection(this.urisRefUpdates.get(uri));
    }

    public static PushOperationSpecification create(Repository repository, RemoteConfig config, Collection<RefSpec> refSpecs) throws IOException {
        PushOperationSpecification result = new PushOperationSpecification();
        Collection remoteRefUpdates = Transport.findRemoteRefUpdatesFor((Repository)repository, refSpecs, (Collection)config.getFetchRefSpecs());
        boolean added = false;
        for (URIish uri : config.getPushURIs()) {
            result.addURIRefUpdates(uri, PushOperationSpecification.copyUpdates(remoteRefUpdates, false));
            added = true;
        }
        if (!added && !config.getURIs().isEmpty()) {
            result.addURIRefUpdates((URIish)config.getURIs().get(0), remoteRefUpdates);
        }
        return result;
    }

    public static Collection<RemoteRefUpdate> copyUpdates(Collection<RemoteRefUpdate> refUpdates, boolean withExpectedOid) throws IOException {
        ArrayList<RemoteRefUpdate> copy = new ArrayList<RemoteRefUpdate>(refUpdates.size());
        for (RemoteRefUpdate rru : refUpdates) {
            copy.add(new RemoteRefUpdate(rru, withExpectedOid ? rru.getExpectedOldObjectId() : null));
        }
        return copy;
    }
}

