/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(label="Class to Association", description="")
public class ClassToAssociation
extends OperationImplementation {
    @EdaptParameter(main=true, description="Class to be replaced by an association")
    public EClass eClass;
    @EdaptParameter(description="Reference to the source class of the association")
    public EReference sourceReference;
    @EdaptParameter(description="Reference to the target class of the association")
    public EReference targetReference;
    @EdaptParameter(description="Name of the new association")
    public String associationName;

    @EdaptConstraint(restricts="eClass", description="The class must not have any sub types.")
    public boolean checkClassSubClasses(EClass eClass, Metamodel metamodel) {
        return metamodel.getESubTypes(eClass).isEmpty();
    }

    @EdaptConstraint(restricts="sourceReference", description="The source reference must be single-valued and not containment.")
    public boolean checkSourceReference(EReference sourceReference) {
        return !sourceReference.isMany() && !sourceReference.isContainment();
    }

    @EdaptConstraint(restricts="sourceReference", description="The source reference must be defined in the class")
    public boolean checkSourceReferenceInClass(EReference sourceReference) {
        return this.eClass.getEStructuralFeatures().contains((Object)sourceReference);
    }

    @EdaptConstraint(restricts="targetReference", description="The target reference must be single-valued and not containment.")
    public boolean checkTargetReference(EReference targetReference) {
        return !targetReference.isMany() && !targetReference.isContainment();
    }

    @EdaptConstraint(restricts="targetReference", description="The source reference must be defined in the class")
    public boolean checkTargetReferenceInClass(EReference targetReference) {
        return this.eClass.getEStructuralFeatures().contains((Object)targetReference);
    }

    @EdaptConstraint(description="The class may only be targeted by one containment reference and the opposite of source and target reference.")
    public boolean checkReferences(Metamodel metamodel) {
        EList references = metamodel.getInverse((EModelElement)this.eClass, EcorePackage.eINSTANCE.getEReference_EReferenceType());
        for (EReference reference : references) {
            if (reference.isContainment() || this.sourceReference.getEOpposite() == reference || this.targetReference.getEOpposite() == reference) continue;
            return false;
        }
        return true;
    }

    protected void execute(Metamodel metamodel, Model model) {
        EClass sourceClass = this.sourceReference.getEReferenceType();
        EClass targetClass = this.targetReference.getEReferenceType();
        EReference association = MetamodelFactory.newEReference((EClass)sourceClass, (String)this.associationName, (EClass)targetClass, (int)0, (int)-1);
        for (Instance instance : model.getAllInstances(this.eClass)) {
            Instance source = instance.getLink(this.sourceReference);
            Instance target = instance.getLink(this.targetReference);
            source.add((EStructuralFeature)association, (Object)target);
            model.delete(instance);
        }
        if (this.sourceReference.getEOpposite() != null) {
            metamodel.delete((EModelElement)this.sourceReference.getEOpposite());
        }
        metamodel.delete((EModelElement)this.sourceReference);
        if (this.targetReference.getEOpposite() != null) {
            metamodel.delete((EModelElement)this.targetReference.getEOpposite());
        }
        metamodel.delete((EModelElement)this.targetReference);
        EList references = metamodel.getInverse((EModelElement)this.eClass, EcorePackage.eINSTANCE.getEReference_EReferenceType());
        for (EReference reference : references) {
            metamodel.delete((EModelElement)reference);
        }
        metamodel.delete((EModelElement)this.eClass);
    }
}

