/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.common.usermodel.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.poi.common.usermodel.fonts.FontCharset;
import org.apache.poi.common.usermodel.fonts.FontFamily;
import org.apache.poi.common.usermodel.fonts.FontInfo;
import org.apache.poi.common.usermodel.fonts.FontPitch;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianInputStream;

public class FontHeader
implements FontInfo {
    public static final int REGULAR_WEIGHT = 400;
    private int eotSize;
    private int fontDataSize;
    private int version;
    private int flags;
    private final byte[] panose = new byte[10];
    private byte charset;
    private byte italic;
    private int weight;
    private int fsType;
    private int magic;
    private int unicodeRange1;
    private int unicodeRange2;
    private int unicodeRange3;
    private int unicodeRange4;
    private int codePageRange1;
    private int codePageRange2;
    private int checkSumAdjustment;
    private String familyName;
    private String styleName;
    private String versionName;
    private String fullName;

    public void init(byte[] source, int offset, int length) {
        this.init(new LittleEndianByteArrayInputStream(source, offset, length));
    }

    public void init(LittleEndianInput leis) {
        this.eotSize = leis.readInt();
        this.fontDataSize = leis.readInt();
        this.version = leis.readInt();
        if (this.version != 65536 && this.version != 131073 && this.version != 131074) {
            throw new RuntimeException("not a EOT font data stream");
        }
        this.flags = leis.readInt();
        leis.readFully(this.panose);
        this.charset = leis.readByte();
        this.italic = leis.readByte();
        this.weight = leis.readInt();
        this.fsType = leis.readUShort();
        this.magic = leis.readUShort();
        if (this.magic != 20556) {
            throw new RuntimeException("not a EOT font data stream");
        }
        this.unicodeRange1 = leis.readInt();
        this.unicodeRange2 = leis.readInt();
        this.unicodeRange3 = leis.readInt();
        this.unicodeRange4 = leis.readInt();
        this.codePageRange1 = leis.readInt();
        this.codePageRange2 = leis.readInt();
        this.checkSumAdjustment = leis.readInt();
        int reserved1 = leis.readInt();
        int reserved2 = leis.readInt();
        int reserved3 = leis.readInt();
        int reserved4 = leis.readInt();
        this.familyName = this.readName(leis);
        this.styleName = this.readName(leis);
        this.versionName = this.readName(leis);
        this.fullName = this.readName(leis);
    }

    public InputStream bufferInit(InputStream fontStream) throws IOException {
        LittleEndianInputStream is = new LittleEndianInputStream(fontStream);
        is.mark(1000);
        this.init(is);
        is.reset();
        return is;
    }

    private String readName(LittleEndianInput leis) {
        leis.readShort();
        int nameSize = leis.readUShort();
        byte[] nameBuf = IOUtils.safelyAllocate(nameSize, 1000);
        leis.readFully(nameBuf);
        return new String(nameBuf, 0, nameSize, StandardCharsets.UTF_16LE).trim();
    }

    public boolean isItalic() {
        return this.italic != 0;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isBold() {
        return this.getWeight() > 400;
    }

    public byte getCharsetByte() {
        return this.charset;
    }

    @Override
    public FontCharset getCharset() {
        return FontCharset.valueOf(this.getCharsetByte());
    }

    @Override
    public FontPitch getPitch() {
        byte familyKind = this.panose[0];
        switch (familyKind) {
            default: {
                return FontPitch.VARIABLE;
            }
            case 2: 
            case 4: {
                byte proportion = this.panose[3];
                return proportion == 9 ? FontPitch.FIXED : FontPitch.VARIABLE;
            }
            case 3: 
            case 5: 
        }
        byte spacing = this.panose[3];
        return spacing == 3 ? FontPitch.FIXED : FontPitch.VARIABLE;
    }

    @Override
    public FontFamily getFamily() {
        switch (this.panose[0]) {
            case 0: 
            case 1: {
                return FontFamily.FF_DONTCARE;
            }
            case 2: {
                byte serifStyle = this.panose[1];
                return 10 <= serifStyle && serifStyle <= 15 ? FontFamily.FF_SWISS : FontFamily.FF_ROMAN;
            }
            case 3: {
                return FontFamily.FF_SCRIPT;
            }
            default: {
                return FontFamily.FF_DECORATIVE;
            }
            case 5: 
        }
        return FontFamily.FF_MODERN;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public byte[] getPanose() {
        return this.panose;
    }

    @Override
    public String getTypeface() {
        return this.getFamilyName();
    }

    public int getFlags() {
        return this.flags;
    }
}

