/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class TextEditor
extends AbstractDecoratedTextEditor {
    protected DefaultEncodingSupport fEncodingSupport;

    public TextEditor() {
        if (this.getSourceViewerConfiguration() == null) {
            this.setSourceViewerConfiguration(new TextSourceViewerConfiguration(this.getPreferenceStore()));
        }
    }

    @Override
    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("#TextRulerContext");
        this.setHelpContextId("org.eclipse.ui.text_editor_context");
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
    }

    @Override
    public void dispose() {
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        super.dispose();
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize(this);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    protected void createActions() {
        this.installEncodingSupport();
        super.createActions();
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (IEncodingSupport.class.equals(adapter)) {
            return (T)this.fEncodingSupport;
        }
        return super.getAdapter(adapter);
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    @Override
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (event.getProperty().equals("spellingEnabled")) {
            IAction quickAssistAction;
            ISourceViewer viewer = this.getSourceViewer();
            if (!(viewer instanceof ISourceViewerExtension2)) {
                return;
            }
            ((ISourceViewerExtension2)viewer).unconfigure();
            viewer.configure(this.getSourceViewerConfiguration());
            if (Boolean.FALSE.equals(event.getNewValue())) {
                SpellingProblem.removeAll((ISourceViewer)this.getSourceViewer(), null);
            }
            if ((quickAssistAction = this.getAction("QuickAssist")) instanceof IUpdate) {
                ((IUpdate)quickAssistAction).update();
            }
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    @Override
    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }
}

