/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EArgument;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.reachabilitygraph.Edge;
import org.eclipse.comma.reachabilitygraph.GsonHelper;
import org.eclipse.comma.reachabilitygraph.Node;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraph;

public class DeterministicScenarios {
    final List<List<Object>> scenarios = new ArrayList<List<Object>>();
    final ReachabilityGraph graph;

    private DeterministicScenarios(ReachabilityGraph graph) {
        this.graph = graph;
    }

    public static DeterministicScenarios fromGraph(ReachabilityGraph graph) {
        DeterministicScenarios deterministicScenarios = new DeterministicScenarios(graph);
        ArrayList<Object> scenario = new ArrayList<Object>();
        ArrayList<Edge> visitedEdges = new ArrayList<Edge>();
        deterministicScenarios.walkRecursive(graph.initial, visitedEdges, scenario);
        return deterministicScenarios;
    }

    private void walkRecursive(Node currentNode, List<Edge> visitedEdges, List<Object> scenarioIn) {
        ArrayList<Object> scenario = new ArrayList<Object>(scenarioIn);
        boolean noEdges = true;
        scenario.add(currentNode);
        for (Edge edge : this.graph.edges) {
            if (edge.source != currentNode || visitedEdges.contains(edge)) continue;
            noEdges = false;
            visitedEdges.add(edge);
            ArrayList<Object> scenarioOut = new ArrayList<Object>(scenario);
            scenarioOut.add(edge);
            this.walkRecursive(edge.target, visitedEdges, scenarioOut);
        }
        if (noEdges) {
            this.scenarios.add(scenario);
        }
    }

    public List<List<Object>> getScenariosEntries() {
        ArrayList<List<Object>> scenariosEntries = new ArrayList<List<Object>>();
        for (List<Object> scenario : this.scenarios) {
            ArrayList<EAction> scenarioEntries = new ArrayList<EAction>();
            for (Object nodeOrEdge : scenario) {
                if (!(nodeOrEdge instanceof Edge)) continue;
                Edge edge = (Edge)nodeOrEdge;
                scenarioEntries.addAll(edge.entries);
            }
            scenariosEntries.add(scenarioEntries);
        }
        return scenariosEntries;
    }

    private static String variableToString(EVariable variable) {
        if (variable.type == EVariableType.ANY) {
            return "*";
        }
        if (variable.value == null) {
            return "null";
        }
        if (variable.type == EVariableType.VECTOR) {
            String value = variable.getValueVector().stream().map(v -> DeterministicScenarios.variableToString(v)).collect(Collectors.joining("_"));
            return String.format("[%s]", value);
        }
        if (variable.type == EVariableType.RECORD) {
            String value = variable.getValueRecord().entrySet().stream().map(e -> String.format("%s_%s", e.getKey(), DeterministicScenarios.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        if (variable.type == EVariableType.MAP) {
            String value = variable.getValueMap().entrySet().stream().map(e -> String.format("%s_%s", DeterministicScenarios.variableToString((EVariable)e.getKey()), DeterministicScenarios.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        return variable.value.toString();
    }

    private static String argumentsToString(List<EArgument> arguments, String mask) {
        return arguments.stream().map(a -> a.direction.equals(mask) ? "_" : DeterministicScenarios.variableToString((EVariable)a)).collect(Collectors.joining(", "));
    }

    public String toJSON(boolean pretty) {
        return GsonHelper.toJSON(this, pretty);
    }

    public String debugText() {
        LinkedHashMap nodeCount = new LinkedHashMap();
        this.graph.nodes.forEach(n -> {
            Integer n2 = nodeCount.put(n, 0);
        });
        this.scenarios.forEach(s -> s.stream().filter(n -> n instanceof Node).forEach(n -> {
            Integer n2 = nodeCount.put((Node)n, (Integer)nodeCount.get(n) + 1);
        }));
        LinkedHashMap edgeCount = new LinkedHashMap();
        this.graph.edges.forEach(e -> {
            Integer n = edgeCount.put(e, 0);
        });
        this.scenarios.forEach(s -> s.stream().filter(e -> e instanceof Edge).forEach(e -> {
            Integer n = edgeCount.put((Edge)e, (Integer)edgeCount.get(e) + 1);
        }));
        String result = "Depth: " + this.graph.depth + " (max depth: " + this.graph.maxDepth + ")\n" + "Scenarios: " + this.scenarios.size() + "\n" + "Transitions: " + this.scenarios.stream().map(s -> s.stream().filter(e -> e instanceof Edge).collect(Collectors.toList()).size()).reduce(0, Integer::sum) + "\n" + "Nodes hit: " + nodeCount.values().stream().filter(v -> v != 0).collect(Collectors.toList()).size() / nodeCount.values().size() * 100 + "%" + "\n" + "Edges hit: " + edgeCount.values().stream().filter(v -> v != 0).collect(Collectors.toList()).size() / edgeCount.values().size() * 100 + "%" + "\n" + "\n";
        result = String.valueOf(result) + "Nodes\n";
        ArrayList nodeCountSorted = new ArrayList(nodeCount.entrySet());
        nodeCountSorted.sort(Map.Entry.comparingByValue().reversed());
        for (Map.Entry entry : nodeCountSorted) {
            result = String.valueOf(result) + entry.getValue() + "\t: " + ((Node)entry.getKey()).name + "\n";
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "Edges\n";
        ArrayList arrayList = new ArrayList(edgeCount.entrySet());
        arrayList.sort(Map.Entry.comparingByValue().reversed());
        for (Map.Entry entry : arrayList) {
            result = String.valueOf(result) + entry.getValue() + "\t: " + ((Edge)entry.getKey()).source.name + " to " + ((Edge)entry.getKey()).target.name + "\n";
        }
        result = String.valueOf(result) + "\n\nLegend: C = Command, R = CommandReply, N = Notification, S = Signal\n";
        result = String.valueOf(result) + "Not applicable arguments are masked with '_ , e.g. for a Command all out parameters will be masked with '_'\n";
        result = String.valueOf(result) + "In case scenarios are generated for component all actions are in the form of PORT.CONNECTION.ACTION (e.g. myPort.myConnection.myMethod())\n";
        for (List list : this.scenarios) {
            result = String.valueOf(result) + String.format("\nScenario %d:\n", this.scenarios.indexOf(list) + 1);
            for (Edge edge : list.stream().filter(e -> e instanceof Edge).map(e -> (Edge)e).collect(Collectors.toList())) {
                for (EAction action : edge.entries) {
                    ECommand a;
                    String prefix = "";
                    if (action.connection != null) {
                        prefix = String.valueOf(action.connection.port) + "." + action.connection.id + ".";
                    }
                    if (action instanceof ECommand) {
                        a = (ECommand)action;
                        result = String.valueOf(result) + String.format("C: %s%s(%s)\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, "out"));
                        continue;
                    }
                    if (action instanceof EReply) {
                        a = (EReply)action;
                        String returnValue = a.returnValue != null ? DeterministicScenarios.variableToString(a.returnValue) : "void";
                        result = String.valueOf(result) + String.format("R: %s%s(%s) -> %s\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, "in"), returnValue);
                        continue;
                    }
                    if (action instanceof ENotification) {
                        a = (ENotification)action;
                        result = String.valueOf(result) + String.format("N: %s%s(%s)\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, ""));
                        continue;
                    }
                    if (action instanceof ESignal) {
                        a = (ESignal)action;
                        result = String.valueOf(result) + String.format("S: %s%s(%s)\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, ""));
                        continue;
                    }
                    throw new RuntimeException("Not supported");
                }
            }
        }
        return result;
    }
}

