/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.comma.monitoring.lib.CComponentConstraintMonitor;
import org.eclipse.comma.monitoring.lib.CComponentConstraintResult;
import org.eclipse.comma.monitoring.lib.CComponentMonitoringContext;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraint;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintError;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintMonitorResult;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintResult;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintState;
import org.eclipse.comma.monitoring.lib.CPathDescription;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.utils.CTraceSerializer;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public class CFunctionalConstraintMonitor
extends CComponentConstraintMonitor {
    private CComponentMonitoringContext context;
    private CFunctionalConstraint constraint;
    private Function<CObservedMessage, Boolean> filter;
    private List<CFunctionalConstraintState> componentExecutionStates;
    private CTraceSerializer traceSerializer;
    private boolean inErrorState;
    private CFunctionalConstraintMonitorResult funcConstraintResult;
    private CComponentConstraintResult result;

    public CFunctionalConstraintMonitor(CComponentMonitoringContext context, CFunctionalConstraint constraint, Function<CObservedMessage, Boolean> filter) {
        this.context = context;
        this.constraint = constraint;
        this.filter = filter;
        this.inErrorState = false;
        this.componentExecutionStates = Arrays.asList(constraint.getInitialStates());
        String traceFile = context.getTraceFile(constraint.getName());
        this.traceSerializer = new CTraceSerializer(traceFile);
        this.funcConstraintResult = new CFunctionalConstraintMonitorResult(constraint.getName(), traceFile);
        this.result = new CComponentConstraintResult();
        this.result.addFunctionaConstraintResult(this.funcConstraintResult);
    }

    @Override
    public void consume(CObservedMessage message, List<CPathDescription> pathDescriptions, String port) throws Exception {
        if (this.inErrorState) {
            return;
        }
        this.updateExecutionStates(message, pathDescriptions, port);
        if (this.componentExecutionStates.isEmpty()) {
            if (this.filter.apply(message).booleanValue()) {
                this.traceSerializer.processEvent(message);
            }
            this.handleError();
            return;
        }
        if (this.filter.apply(message).booleanValue()) {
            this.traceSerializer.processEvent(message);
            ArrayList<CFunctionalConstraintState> newComponentExecutionStates = new ArrayList<CFunctionalConstraintState>();
            for (CFunctionalConstraintState state : this.componentExecutionStates) {
                this.constraint.setState(state);
                CFunctionalConstraintResult result = this.constraint.consume(message);
                if (result.isError) continue;
                newComponentExecutionStates.add(result.newState);
            }
            if (newComponentExecutionStates.isEmpty()) {
                this.handleError();
            } else {
                this.componentExecutionStates = newComponentExecutionStates;
            }
        }
    }

    private void handleError() {
        this.inErrorState = true;
        CFunctionalConstraintError error = new CFunctionalConstraintError();
        error.setErrorContext(this.traceSerializer.getLatestTrace());
        String umlErrorFileName = this.context.getErrorUMLFile(this.constraint.getName());
        error.setUMLFile(umlErrorFileName);
        this.funcConstraintResult.setError(error);
        try {
            FileWriter writer = new FileWriter(this.context.getResultsFile(this.constraint.getName()), false);
            writer.write(this.funcConstraintResult.toString());
            writer.close();
            FileWriter umlWriter = new FileWriter(umlErrorFileName, false);
            umlWriter.write(error.toUML());
            umlWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateExecutionStates(CObservedMessage message, List<CPathDescription> pathDescriptions, String port) {
        String connection = "";
        String instanceName = this.context.getComponentInstanceName();
        connection = message.getDestination().equals(instanceName) ? message.getSource() : message.getDestination();
        ArrayList<CFunctionalConstraintState> newComponentExecutionStates = new ArrayList<CFunctionalConstraintState>();
        for (CFunctionalConstraintState executionState : this.componentExecutionStates) {
            CFunctionalConstraintState newExecutionState;
            Map<String, CPathDescription> portConnections = executionState.get_commaVar_portsStates().get(port);
            if (portConnections == null) {
                for (CPathDescription pd : pathDescriptions) {
                    newExecutionState = (CFunctionalConstraintState)Utils.deepCopy(executionState);
                    HashMap<String, CPathDescription> connections = new HashMap<String, CPathDescription>();
                    connections.put(connection, (CPathDescription)Utils.deepCopy(pd));
                    newExecutionState.get_commaVar_portsStates().put(port, connections);
                    newComponentExecutionStates.add(newExecutionState);
                }
                continue;
            }
            if (!portConnections.containsKey(connection)) {
                for (CPathDescription pd : pathDescriptions) {
                    if (!this.context.isSingletonPort(port)) {
                        newExecutionState = (CFunctionalConstraintState)Utils.deepCopy(executionState);
                        newExecutionState.get_commaVar_portsStates().get(port).put(connection, (CPathDescription)Utils.deepCopy(pd));
                        newComponentExecutionStates.add(newExecutionState);
                        continue;
                    }
                    newExecutionState = (CFunctionalConstraintState)Utils.deepCopy(executionState);
                    newExecutionState.get_commaVar_portsStates().get(port).entrySet().forEach(p -> {
                        CPathDescription cPathDescription2 = p.setValue((CPathDescription)Utils.deepCopy(pd));
                    });
                    newExecutionState.get_commaVar_portsStates().get(port).put(connection, (CPathDescription)Utils.deepCopy(pd));
                    newComponentExecutionStates.add(newExecutionState);
                }
                continue;
            }
            for (CPathDescription pd : pathDescriptions) {
                String path = portConnections.get(connection).getPathId();
                if (!pd.getPathId().startsWith(path)) continue;
                CFunctionalConstraintState newExecutionState2 = (CFunctionalConstraintState)Utils.deepCopy(executionState);
                newExecutionState2.get_commaVar_portsStates().get(port).put(connection, (CPathDescription)Utils.deepCopy(pd));
                newComponentExecutionStates.add(newExecutionState2);
                if (!this.context.isSingletonPort(port)) continue;
                newExecutionState2.get_commaVar_portsStates().get(port).entrySet().forEach(p -> {
                    CPathDescription cPathDescription2 = p.setValue((CPathDescription)Utils.deepCopy(pd));
                });
            }
        }
        this.componentExecutionStates = newComponentExecutionStates;
    }

    @Override
    public CComponentConstraintResult getResults() {
        return this.result;
    }

    @Override
    public void traceEnded() {
        if (!this.inErrorState) {
            try {
                FileWriter writer = new FileWriter(this.context.getResultsFile(this.constraint.getName()), false);
                writer.write(this.funcConstraintResult.toString());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

