/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.component.validation;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.VariableDeclBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPackage;
import org.eclipse.comma.behavior.component.component.EventReception;
import org.eclipse.comma.behavior.component.component.ExpressionConnectionState;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.FunctionalConstraintsBlock;
import org.eclipse.comma.behavior.component.component.PortAwareEvent;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.component.validation.AbstractComponentValidator;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinition;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.types.types.Import;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ComponentValidator
extends AbstractComponentValidator {
    @Check
    public void checkImportForValidity(Import imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getImport_ImportURI());
        } else {
            boolean _not_1;
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            EObject _head = (EObject)IteratorExtensions.head((Iterator)r.getAllContents());
            boolean bl2 = _not_1 = !(_head instanceof InterfaceDefinition);
            if (_not_1) {
                this.error("The imported resource is not an interface definition.", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getImport_ImportURI());
            }
        }
    }

    @Check
    public void checkDuplicatedPortNames(Component c) {
        this.checkForNameDuplications((Iterable)c.getPorts(), "port", null, new String[]{"port"});
    }

    @Check
    public void checkDuplicatedFuncConstraintNames(FunctionalConstraintsBlock fcb) {
        this.checkForNameDuplications((Iterable)fcb.getFunctionalConstraints(), "constraint", null, new String[]{"constraint"});
    }

    @Check
    public void checkDuplicatedStateNamesFunctionalConstraint(StateBasedFunctionalConstraint fc) {
        this.checkForNameDuplications((Iterable)fc.getStates(), "state", null, new String[]{"state"});
    }

    @Check
    public void checkInitialState(StateBasedFunctionalConstraint fc) {
        boolean _equals;
        boolean _greaterThan;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        Iterable initialStates = IterableExtensions.filter(fc.getStates(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)initialStates);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.error("More than one initial state", (EObject)fc, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        int _size_1 = IterableExtensions.size((Iterable)initialStates);
        boolean bl2 = _equals = _size_1 == 0;
        if (_equals) {
            this.error("Missing initial state", (EObject)fc, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkUsedEventsList(StateBasedFunctionalConstraint fc) {
        EList<EventPattern> _usedEvents = fc.getUsedEvents();
        for (EventPattern ev1 : _usedEvents) {
            EList<EventPattern> _usedEvents_1 = fc.getUsedEvents();
            for (EventPattern ev2 : _usedEvents_1) {
                boolean _isSubsumedBy;
                boolean _notEquals;
                boolean bl = _notEquals = !Objects.equal((Object)ev1, (Object)ev2);
                if (!_notEquals || !(_isSubsumedBy = ComponentUtilities.isSubsumedBy(ev1, ev2))) continue;
                this.warning("The event is duplicated or subsumed by another event", (EObject)fc, (EStructuralFeature)ComponentPackage.Literals.STATE_BASED_FUNCTIONAL_CONSTRAINT__USED_EVENTS, fc.getUsedEvents().indexOf((Object)ev1));
            }
        }
    }

    @Check
    public void checkEventReceptions(StateBasedFunctionalConstraint fc) {
        List _allContentsOfType = EcoreUtil2.getAllContentsOfType((EObject)fc, EventReception.class);
        for (final EventReception er : _allContentsOfType) {
            boolean _not;
            Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern e) {
                    return ComponentUtilities.isSubsumedBy(er.getEvent(), e);
                }
            };
            boolean _exists = IterableExtensions.exists(fc.getUsedEvents(), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            this.error("Event is not declared in used events list", (EObject)er, (EStructuralFeature)ComponentPackage.Literals.EVENT_RECEPTION__EVENT);
        }
    }

    @Check
    public void checkUnusedVarsFunctionalConstraint(final FunctionalConstraint fc) {
        ArrayList variables = new ArrayList();
        variables.addAll(fc.getVars());
        Functions.Function1<ExpressionVariable, Variable> _function = new Functions.Function1<ExpressionVariable, Variable>(){

            public Variable apply(ExpressionVariable it) {
                return it.getVariable();
            }
        };
        variables.removeAll(ListExtensions.map((List)EcoreUtil2.getAllContentsOfType((EObject)fc, ExpressionVariable.class), (Functions.Function1)_function));
        Consumer<Variable> _function_1 = new Consumer<Variable>(){

            @Override
            public void accept(Variable it) {
                ComponentValidator.this.warning("Unused variable.", (EStructuralFeature)ActionsPackage.Literals.VARIABLE_DECL_BLOCK__VARS, fc.getVars().indexOf((Object)it));
            }
        };
        variables.forEach(_function_1);
    }

    @Check
    public void checkTypingEventReception(EventReception er) {
        boolean _not;
        boolean _tripleEquals;
        Expression _condition = er.getCondition();
        boolean bl = _tripleEquals = _condition == null;
        if (_tripleEquals) {
            return;
        }
        TypeObject t = this.typeOf(er.getCondition());
        boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.boolType);
        boolean bl2 = _not = !_subTypeOf;
        if (_not) {
            this.error("Type mismatch: the type of the condition must be boolean", (EStructuralFeature)ComponentPackage.Literals.EVENT_RECEPTION__CONDITION);
        }
    }

    @Check
    public void checkTypingPredicateFunctionalConstraint(PredicateFunctionalConstraint fc) {
        boolean _not;
        TypeObject t = this.typeOf(fc.getExpression());
        boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.boolType);
        boolean bl = _not = !_subTypeOf;
        if (_not) {
            this.error("Type mismatch: the type of the expression must be boolean", (EStructuralFeature)ComponentPackage.Literals.PREDICATE_FUNCTIONAL_CONSTRAINT__EXPRESSION);
        }
    }

    @Check
    public void checkConnectionVariableInPort(PortAwareEvent ev) {
        boolean _tripleNotEquals;
        ExpressionVariable _idVar = ev.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            boolean _not;
            TypeObject t = this.typeOf((Expression)ev.getIdVar());
            boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("The type of the variable must be id", (EStructuralFeature)ComponentPackage.Literals.PORT_AWARE_EVENT__ID_VAR);
            }
        }
    }

    @Check
    public void checkConnectionVariableInExpr(ExpressionConnectionState expr) {
        boolean _tripleNotEquals;
        ExpressionVariable _idVar = expr.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            boolean _not;
            TypeObject t = this.typeOf((Expression)expr.getIdVar());
            boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("The type of the variable must be id", (EStructuralFeature)ComponentPackage.Literals.EXPRESSION_CONNECTION_STATE__ID_VAR);
            }
        }
    }

    @Check
    public void checkForIdType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("id")) {
            boolean _not;
            EObject _eContainer = t.eContainer().eContainer();
            boolean bl = _not = !(_eContainer instanceof VariableDeclBlock);
            if (_not) {
                this.error("Usage of type id is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
            }
        }
    }

    @Check
    public void checkCommandInReply(CommandReply cr) {
        boolean _not;
        boolean _tripleEquals;
        CommandEvent _command = cr.getCommand();
        boolean bl = _tripleEquals = _command == null;
        if (_tripleEquals) {
            return;
        }
        boolean _contains = cr.getPort().getInterface().getCommands().contains((Object)cr.getCommand().getEvent());
        boolean bl2 = _not = !_contains;
        if (_not) {
            String _name = cr.getPort().getName();
            String _plus = "Command not defined in the interface of the reply's port " + _name;
            this.error(_plus, (EStructuralFeature)ActionsPackage.Literals.COMMAND_REPLY__COMMAND);
        } else if (cr.eContainer() instanceof EventReception && !cr.getParameters().isEmpty()) {
            InterfaceEvent _event = cr.getCommand().getEvent();
            this.checkReplyAgainstCommand((Command)_event, cr);
        }
    }

    public TypeObject typeOf(Expression exp) {
        Object _xifexpression = null;
        _xifexpression = exp != null && (exp instanceof ExpressionInterfaceState || exp instanceof ExpressionConnectionState) ? this.boolType : super.typeOf(exp);
        return _xifexpression;
    }
}

